/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.LanguageInfo;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/resource/debug/languages/file-to-language-mapping")
public class DebugFileToClassifiedLanguageMappingService
extends ApiBase {
    @GET
    @Operation(summary="Get file to language mapping", description="Returns for all files of the project as which language they are currently classified.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public Map<String, LanguageInfo> getLanguagesOfFiles(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        TokenElementIndex tokenElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", this.determineHistoryOption(commit));
        HashMap<String, LanguageInfo> result = new HashMap<String, LanguageInfo>();
        for (BasicTokenElementInfo tokenElementInfo : tokenElementIndex.getAllTokenElements().extractSecondList()) {
            result.put(tokenElementInfo.getUniformPath(), new LanguageInfo(tokenElementInfo.getLanguage(), tokenElementInfo.getIsFileLanguageSetByUser()));
        }
        return result;
    }
}

