/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.ContentIndexSynchronizer;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.IndexAwareCPreprocessor;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.InitialMacroDefinitionsDetail;
import com.teamscale.index.resource.element_details.PrependDirectivesDetail;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.MacroExpansionStepsLogger;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/preprocessor/debug/expansion")
public class PreprocessorExpansionDebugService
extends ApiBase {
    public static final String CONTEXT_FILE_PARAMETER = "contextFile";
    public static final String CONTEXT_LINE_PARAMETER = "contextLine";
    public static final String SHOW_DEFINED_MACROS_PARAMETER = "showDefinedMacros";
    public static final String USE_SYNCHRONIZER_OUTPUT_PARAMETER = "useSynchronizerOutput";
    public static final String CODE_PARAMETER = "code";
    public static final String CODE_SCOPE_PARAMETER = "code-scope";
    private static final String EXPANSION_STEPS_EXPLANATION = "The following steps explain how the macro call is expanded.\nEach macro expansion is executed in several steps, sometimes requiring to expand nested macro calls (we will show this with indentation in the log).\nWhen starting a macro expansion, we show the current disabling context (list of macro names that will not be expanded). If one of these macro names appears in the expansion (and would be expanded), it is not expanded and the token is marked with a no_expand flag. All no_expand tokens are marked with a \u00b0 in the log.";

    @GET
    @Produces(value={"text/plain"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Preprocessor Expansion Debugging", tags={"Debugging"}, description="Returns debugging information on a preprocessing operation. This uses our own C/C++ preprocessor and only works for languages using this preprocessor. The service first preprocesses all contents of a given file up to a given line (in particular #include and #define directives). Then it preprocesses a given code snippet using all defines gathered during the file preprocessing. The intermediate steps of the preprocessor during this second expansion are returned including information about included/unresolved files and defined/used macros.", responses={@ApiResponse(responseCode="404", description="Element with the given name does not exist!")})
    public String getDebugRepresentation(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="code") @Parameter(description="The code that will be expanded. If no code is given (default setting) expands the actual source code starting in the given line and ending with the first line ending that is not a line continuation.") @DefaultValue(value="") String code, @QueryParam(value="contextFile") @Parameter(description="We simulate that the given code is in this file.", required=true) String filename, @QueryParam(value="contextLine") @Parameter(description="We simulate that the given code is in this line of the given file. Defaults to first line.") @DefaultValue(value="0") int endline, @QueryParam(value="showDefinedMacros") @Parameter(description="Whether to display all macros defined at the given line in the given file. Defaults to false since this is a lot of information.") @DefaultValue(value="false") boolean showDefinedMacros, @QueryParam(value="useSynchronizerOutput") @Parameter(description="Whether to use the output from the content synchronizer, that already does preprocessing and parsing. Defaults to false since we might also want to prevent potential bugs from that stage.") @DefaultValue(value="false") boolean useSynchronizerOutput, @QueryParam(value="code-scope") @Parameter(description="The code scope to retrieving the predefined preprocessor macros from the analysis profile. Defaults to the default code scope") @Nullable String codeScope) throws StorageException {
        BasicTokenElementIndex basicTokenElementIndex = (BasicTokenElementIndex)this.getProjectStorageSystem().openProjectIndex(BasicTokenElementIndex.class, this.determineHistoryOption(commit));
        Object tokenElement = useSynchronizerOutput ? PreprocessorExpansionDebugService.loadElement(filename, arg_0 -> ((TokenElementIndex)((TokenElementIndex)this.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", this.determineHistoryOption(commit)))).getTokenElement(arg_0)) : PreprocessorExpansionDebugService.loadElement(filename, arg_0 -> ((BasicTokenElementIndex)basicTokenElementIndex).getTokenElement(arg_0));
        if (codeScope == null) {
            codeScope = CodeScopeAware.DEFAULT_CODE_SCOPE.name();
        }
        if (code.isEmpty()) {
            code = PreprocessorExpansionDebugService.determinePreprocessorCodeInLine(endline, tokenElement);
        }
        String emptyLinesBeforeCode = "\n".repeat(Math.max(0, endline - 1));
        List queryCode = ScannerUtils.getTokens((String)(emptyLinesBeforeCode + code), (ELanguage)tokenElement.getLanguage(), (String)tokenElement.getUniformPath());
        String inputRepresentation = PreprocessorExpansionDebugService.generateInputRepresentation(tokenElement.getUniformPath(), endline, this.determineHistoryOption(commit), queryCode);
        IndexAwareCPreprocessor preprocessor = this.createPreprocessor((BasicTokenElementInfo)tokenElement, commit, basicTokenElementIndex, useSynchronizerOutput, new CodeScopeName(codeScope));
        String outputRepresentation = PreprocessorExpansionDebugService.generateOutputRepresentation(tokenElement, preprocessor, endline, showDefinedMacros, queryCode);
        return inputRepresentation + outputRepresentation;
    }

    private IndexAwareCPreprocessor createPreprocessor(BasicTokenElementInfo tokenElement, UnresolvedCommitDescriptor commit, BasicTokenElementIndex basicTokenElementIndex, boolean useSynchronizerOutput, CodeScopeName codeScopeName) throws StorageException {
        InitialMacroDefinitionsDetail initialMacroDefinitionsDetail;
        IncludePathDetail includePathDetail;
        PathLookupIndex pathLookupIndex = (PathLookupIndex)this.getProjectStorageSystem().openProjectIndex(PathLookupIndex.class, this.determineHistoryOption(commit));
        MetaIndex metaIndex = (MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null);
        SystemIncludeFileCacheIndex systemIncludeFileCacheIndex = this.openGlobalIndex(SystemIncludeFileCacheIndex.class);
        SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create((MetaIndex)metaIndex, (SystemIncludeFileCacheIndex)systemIncludeFileCacheIndex);
        FileIncludeLookup includeLookup = new FileIncludeLookup((IMatchingPathsLookup)pathLookupIndex, systemIncludeFileLookup);
        if (useSynchronizerOutput) {
            includePathDetail = tokenElement.getFirstDetailOfType(IncludePathDetail.class).orElse(new IncludePathDetail());
            initialMacroDefinitionsDetail = tokenElement.getFirstDetailOfType(InitialMacroDefinitionsDetail.class).orElse(new InitialMacroDefinitionsDetail(Collections.emptyList()));
        } else {
            CompilationCommand compilationCommand = this.loadCompilationCommand(commit, tokenElement);
            PrependDirectivesDetail definitionsDetail = ContentIndexSynchronizer.buildPrependDirectivesDetail((BasicTokenElementInfo)tokenElement, (CompilationCommand)compilationCommand, this.getDefaultDefinitionsFromAnalysisProfile(tokenElement.getLanguage(), codeScopeName));
            includePathDetail = ContentIndexSynchronizer.buildIncludePathDetail((BasicTokenElementInfo)tokenElement, (CompilationCommand)compilationCommand, (CppSystemIncludeDirectories)((CppSystemIncludeDirectories)metaIndex.getValue(CppSystemIncludeDirectories.class)));
            initialMacroDefinitionsDetail = ContentIndexSynchronizer.buildInitialMacroDefinitionsDetail((BasicTokenElementInfo)tokenElement, (PrependDirectivesDetail)definitionsDetail, (List)includePathDetail.getResolvedIncludeSearchPaths(), (FileIncludeLookup)includeLookup, new HashSet(), new ConcurrentHashMap(), (BasicTokenElementIndex)basicTokenElementIndex);
        }
        return new IndexAwareCPreprocessor(initialMacroDefinitionsDetail.definitions, includePathDetail.getResolvedIncludeSearchPaths(), includeLookup, new HashSet(), new ConcurrentHashMap(), basicTokenElementIndex, true, true);
    }

    private CompilationCommand loadCompilationCommand(UnresolvedCommitDescriptor commit, BasicTokenElementInfo tokenElement) throws StorageException {
        CompilationCommand compilationCommand = (CompilationCommand)this.openProjectIndex(CompileCommandIndex.class, this.determineHistoryOption(commit)).getCommands(Collections.singletonList(tokenElement.getUniformPath())).get(0);
        if (compilationCommand == null || compilationCommand.getDefinitions() == null) {
            return CompilationCommand.EMPTY_CPP_COMMAND;
        }
        return compilationCommand;
    }

    private static String determinePreprocessorCodeInLine(int endline, BasicTokenElementInfo tokenElement) {
        List lines = StringUtils.splitLinesAsList((String)tokenElement.getText());
        StringBuilder code = new StringBuilder();
        for (int i = endline; i < lines.size(); ++i) {
            code.append((String)lines.get(i));
            code.append("\n");
            if (!((String)lines.get(i)).endsWith("\\")) break;
        }
        return code.toString();
    }

    private static String generateOutputRepresentation(BasicTokenElementInfo tokenElement, IndexAwareCPreprocessor preprocessor, int endline, boolean showDefinedMacros, List<IToken> queryCode) {
        CPreprocessor.PreprocessorUsageInformation usageInfoFromFileContent = PreprocessorExpansionDebugService.loadDefinesIn(preprocessor, tokenElement, endline);
        StringWriter stringWriter = new StringWriter();
        preprocessor.setExpansionStepsLogger(new MacroExpansionStepsLogger((Writer)stringWriter));
        List replacements = preprocessor.computeReplacementsForTranslationUnit(tokenElement.getUniformPath(), queryCode);
        String expansionLog = stringWriter.toString();
        Object representation = PreprocessorExpansionDebugService.generateBasicRepresentation(queryCode, replacements, usageInfoFromFileContent);
        StringBuilder builder = new StringBuilder();
        builder.append(PreprocessorExpansionDebugService.generateErrorRepresentation(replacements));
        builder.append("\nall known macros:\n");
        if (showDefinedMacros) {
            PreprocessorExpansionDebugService.appendMacrosTable(new HashSet<MacroDefinition>(preprocessor.getCurrentDefines().getAllDefines()), builder);
        } else {
            builder.append("-- omitted -- use url parameter &showDefinedMacros=true to show them");
        }
        representation = (String)representation + builder.toString();
        representation = (String)representation + "\n\nThe following steps explain how the macro call is expanded.\nEach macro expansion is executed in several steps, sometimes requiring to expand nested macro calls (we will show this with indentation in the log).\nWhen starting a macro expansion, we show the current disabling context (list of macro names that will not be expanded). If one of these macro names appears in the expansion (and would be expanded), it is not expanded and the token is marked with a no_expand flag. All no_expand tokens are marked with a \u00b0 in the log.\n\nExpansion steps:\n" + expansionLog;
        return representation;
    }

    private static String generateErrorRepresentation(List<PreprocessorTokenReplacement> replacements) {
        StringBuilder errors = new StringBuilder();
        for (PreprocessorTokenReplacement replacement : replacements) {
            if (replacement.errorMessage == null) continue;
            errors.append(replacement.errorMessage);
            errors.append("\n");
        }
        if (errors.isEmpty()) {
            return "\nNo errors encountered during preprocessing of the given code\n";
        }
        return "\nErrors encountered during preprocessing of the given code:\n" + String.valueOf(errors) + "\n";
    }

    private static String generateInputRepresentation(String uniformPath, int endline, HistoryAccessOption determineHistoryOption, List<IToken> code) {
        Object representation = "";
        representation = (String)representation + "Input ------------------------\n";
        representation = (String)representation + "uniform path: " + uniformPath + "\n";
        representation = (String)representation + "contextLine: " + endline + "\n";
        representation = (String)representation + "commit: " + determineHistoryOption.toString() + "\n";
        String codeText = TokenStreamTextUtils.concatTokenTexts(code, (String)" ");
        representation = (String)representation + "code: " + codeText + "\n";
        if (codeText.startsWith("\"")) {
            representation = (String)representation + "\tAttention: your code starts with an \", and is scanned as a string. Maybe an URL encoding error?";
        }
        return representation;
    }

    private List<IToken> getDefaultDefinitionsFromAnalysisProfile(ELanguage language, CodeScopeName codeScopeName) throws StorageException {
        AnalysisProfile embeddedProfile = ((ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class)).getEmbeddedProfile(codeScopeName);
        if (embeddedProfile == null) {
            return Collections.emptyList();
        }
        String predefinedDirectivesText = embeddedProfile.getOptionValue("Predefined Preprocessor Macros");
        if (predefinedDirectivesText == null) {
            return Collections.emptyList();
        }
        return ScannerUtils.getTokens((String)predefinedDirectivesText, (ELanguage)language, (String)"default defines (analysis profile)");
    }

    private static String generateBasicRepresentation(List<IToken> code, List<PreprocessorTokenReplacement> replacements, CPreprocessor.PreprocessorUsageInformation usageInfoFromFileContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nOutput ------------------------\n");
        sb.append("expansion: " + TokenStreamTextUtils.concatTokenTexts((List)CPreprocessingUtils.applyReplacements(replacements, code), (String)" ") + "\n");
        CPreprocessor.PreprocessorUsageInformation preprocessorUsage = new CPreprocessor.PreprocessorUsageInformation();
        preprocessorUsage.addIncludeInfoFrom(usageInfoFromFileContent);
        for (PreprocessorTokenReplacement replacement : replacements) {
            preprocessorUsage.addFrom(replacement.preprocessorUsageInformation);
        }
        sb.append("\nused macros (isDefined):\n");
        PreprocessorExpansionDebugService.appendMacrosTable(preprocessorUsage.getDefinitionDependencyMacros(), sb);
        sb.append("\nused macros (content):\n");
        PreprocessorExpansionDebugService.appendMacrosTable(preprocessorUsage.getContentDependencyMacros(), sb);
        sb.append("\nincluded files:\n");
        for (String include : CollectionUtils.sort((Collection)preprocessorUsage.getIncludedUniformPaths())) {
            sb.append("\t" + include + "\n");
        }
        sb.append("\nunresolved includes:\n");
        for (String include : CollectionUtils.sort((Collection)preprocessorUsage.getUnresolvedIncludePaths())) {
            sb.append("\t" + include + "\n");
        }
        return sb.toString();
    }

    private static void appendMacrosTable(Set<MacroDefinition> macros, StringBuilder sb) {
        int maxNameLength = macros.stream().map(macro -> macro.macroName.length()).max(Integer::compareTo).orElse(0);
        int maxLocationLength = Math.max("default defines (analysis profile)".length(), macros.stream().map(macro -> macro.macroDeclarationLocation).filter(Objects::nonNull).map(location -> location.toLocationString().length()).max(Integer::compareTo).orElse(0));
        for (MacroDefinition macro2 : PreprocessorExpansionDebugService.sortMacros(macros)) {
            if (macro2.macroDeclarationLocation == null) {
                sb.append(PreprocessorExpansionDebugService.fillWithSpaces("default defines (analysis profile)", maxLocationLength) + "  ");
            } else {
                sb.append(PreprocessorExpansionDebugService.fillWithSpaces(macro2.macroDeclarationLocation.toString(), maxLocationLength) + "  ");
            }
            sb.append(PreprocessorExpansionDebugService.fillWithSpaces(macro2.macroName, maxNameLength) + "  " + String.valueOf(macro2) + "\n");
        }
    }

    private static @NonNull List<MacroDefinition> sortMacros(Set<MacroDefinition> macros) {
        Function<TextRegionLocation, Integer> mapDefaultToEmpty = loc -> {
            if (loc.getUniformPath().equals("default defines (analysis profile)")) {
                return 0;
            }
            return 1;
        };
        Comparator<TextRegionLocation> locationComparator = Comparator.nullsFirst(Comparator.comparing(mapDefaultToEmpty).thenComparing(ElementLocation::getUniformPath).thenComparing(TextRegionLocation::getRawStartLine));
        return CollectionUtils.sort(macros, Comparator.comparing(macro -> macro.macroDeclarationLocation, locationComparator));
    }

    private static String fillWithSpaces(String string, int length) {
        return string + CPreprocessingUtils.getFillerSpaces((String)string, (int)length);
    }

    private static CPreprocessor.PreprocessorUsageInformation loadDefinesIn(IndexAwareCPreprocessor preprocessor, BasicTokenElementInfo basicTokenElementInfo, int endline) {
        List replacements = preprocessor.computeReplacementsForTranslationUnit(basicTokenElementInfo.getUniformPath(), ScannerUtils.getTokens((String)StringUtils.retainHeadLines((String)basicTokenElementInfo.getText(), (int)endline), (ELanguage)basicTokenElementInfo.getLanguage(), (String)basicTokenElementInfo.getUniformPath()));
        CPreprocessor.PreprocessorUsageInformation preprocessorUsage = new CPreprocessor.PreprocessorUsageInformation();
        for (PreprocessorTokenReplacement replacement : replacements) {
            preprocessorUsage.addFrom(replacement.preprocessorUsageInformation);
        }
        return preprocessorUsage;
    }

    private static <T extends BasicTokenElementInfo> T loadElement(String uniformPath, FunctionWithException<String, T, StorageException> contentRetrievalFunction) throws StorageException {
        BasicTokenElementInfo element = (BasicTokenElementInfo)contentRetrievalFunction.apply((Object)(uniformPath = UniformPathUtils.cleanPath((String)uniformPath)));
        if (element == null) {
            throw new NotFoundException("No element of name " + uniformPath + " found!");
        }
        return (T)element;
    }
}

