/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ByteUnit;

@Path(value="api/system/performance/debug/trigger/details.csv")
public class PerformanceDetailsDownloadService
extends PerformanceDataDownloadServiceBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get detailed trigger performance metrics", description="Allows downloading the detailed trigger performance data as CSV. The feature toggle -Dcom.teamscale.log_performance_details=true must be enabled.", tags={"Debugging"})
    public Response getTriggerPerformanceDetails() throws StorageException {
        String entity = this.createCsvContent();
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"performance-trigger-details.csv");
    }

    private String createCsvContent() throws StorageException {
        PairList<PublicProjectId, PerformanceIndexBase> performanceIndexes = this.openPerformanceIndexes();
        StringBuilder builder = new StringBuilder();
        builder.append("Project;State;Trigger;Worker;Start (timestamp);Duration (sec);Storage Calls;Storage Time (sec);Memory (MB);Section Name; Section Time (sec);\n");
        for (int i = 0; i < performanceIndexes.size(); ++i) {
            for (PerformanceDetailEntry detail : ((PerformanceIndexBase)performanceIndexes.getSecond(i)).getAllDetails()) {
                builder.append(detail.getProjectId()).append(";");
                builder.append(detail.getState()).append(";");
                builder.append(detail.getTrigger()).append(";");
                builder.append(detail.getMainWorkerPerformance().workerId()).append(";");
                builder.append(detail.getMainWorkerPerformance().startTime().toEpochMilli()).append(";");
                builder.append(detail.getMainWorkerPerformance().duration().toSeconds()).append(";");
                builder.append(detail.getStorageCalls()).append(";");
                builder.append((double)detail.getStorageTimeMillis() / 1000.0).append(";");
                builder.append(ByteUnit.BYTES.toMebiBytes(detail.getMainWorkerPerformance().maxMemoryBytes())).append(";");
                for (Map.Entry entry : detail.getSectionTimeMillis().entrySet()) {
                    builder.append((String)entry.getKey()).append(";");
                    builder.append((double)((Long)entry.getValue()).longValue() / 1000.0).append(";");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

