/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.method_history;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.commits.ResourceAndMethodHistoryFilter;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import com.teamscale.service.testgap.method_history.MethodHistoryEntriesWrapper;
import com.teamscale.service.testgap.method_history.MethodHistoryServiceBase;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/methods/history/{uniformPath: .*}")
public class MethodHistoryService
extends MethodHistoryServiceBase {
    public static final String START_OFFSET_PARAMETER_NAME = "start-offset";
    public static final String END_OFFSET_PARAMETER_NAME = "end-offset";
    public static final String BASELINE_TIMESTAMP_PARAMETER_NAME = "baseline-timestamp";

    @GET
    @Operation(summary="Get method history", description="Returns the method history entries including changes, renamings or movements and points in time where method has been tested.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MethodHistoryEntriesWrapper getMethodHistory(@Parameter(description="Uniform path to retrieve the metric history for.", required=true, allowEmptyValue=true) @PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="The character-based offset in file on which the method starts (at the specified time).", required=true) @QueryParam(value="start-offset") int startOffset, @Parameter(description="The character-based offset in file on which the method ends (at the specified time).", required=true) @QueryParam(value="end-offset") int endOffset, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="The partitions from which coverage uploads should be retrieved. If not set, all partitions in the project are used.") @QueryParam(value="partitions") Set<String> partitions, @Parameter(description="The cross-annotation projects to retrieve execution information from.") @QueryParam(value="cross-annotation-project-patterns") List<PublicProjectId> crossAnnotationProjects, @Parameter(description="The baseline until to compute detailed history.", allowEmptyValue=true) @QueryParam(value="baseline-timestamp") long baselineTimestamp, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        this.getPermissions().checkReadInProjects(crossAnnotationProjects);
        this.partitions = partitions;
        this.repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        this.userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        this.initializeCrossAnnotator(crossAnnotationProjects);
        CommitDescriptor endCommit = this.resolve(commit);
        OffsetBasedRegion region = new OffsetBasedRegion(startOffset, endOffset);
        SortedSet<UserResolvedMethodHistoryEntry> entries = this.collectMethodHistoryEntries(uniformPath, endCommit, region, baselineTimestamp);
        long lastTestedTimestamp = MethodHistoryService.getLastTestedTimestamp(entries);
        ResourceAndMethodHistoryFilter filter = ResourceAndMethodHistoryFilter.createFromFilterParam(repositoryLogFilter, (CommitAlertIndex)this.getProjectStorageSystem().openProjectIndex(CommitAlertIndex.class, null), commit.getBranchName());
        if (filter != null) {
            entries = filter.filterMethodHistoryEntries(entries, this.repositoryLogIndex, this.openProjectIndex(RepositoryLogFileIndex.class, null));
        }
        return new MethodHistoryEntriesWrapper(entries, this.crossAnnotationExecutionProjects, lastTestedTimestamp);
    }
}

