/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetMethodMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/testgap/debug/dotnet-info-gaps")
public class DotNetDebugInfoGapsService
extends ApiBase {
    @GET
    @Operation(summary="Get paths without binary source mappings", description="Returns a list of all uniform paths of a project for which no binary source mapping is available for the last uploaded version.", tags={"Debugging"}, responses={@ApiResponse(responseCode="404", description="No .NET method mappings available")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public String getPathsWithoutSourceMappings(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.", required=true) @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        if (!this.projectIndexExists("dot-net-method-mappings")) {
            throw new NotFoundException("No .NET method mappings available");
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TokenElementIndex tokenElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        HashSet allUniformPaths = new HashSet(tokenElementIndex.getAllUniformPaths());
        DotNetMethodMappingIndex index = this.openProjectIndex(DotNetMethodMappingIndex.class, historyAccessOption);
        Set uniformPaths = CollectionUtils.mapToSet((Collection)index.getAllMappings().extractSecondList(), SourceLocation::getUniformPath);
        allUniformPaths.removeAll(uniformPaths);
        UnmodifiableList unmappedPathsSorted = CollectionUtils.asSortedUnmodifiableList(allUniformPaths);
        return String.join((CharSequence)StringUtils.LINE_SEPARATOR, (Iterable<? extends CharSequence>)unmappedPathsSorted);
    }
}

