/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.testimpact.ITestImpactServiceApi;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.PrioritizableTestsRetriever;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.TestPrioritizationData;
import com.teamscale.service.testimpact.TestReductionApiBase;
import com.teamscale.service.testimpact.TiaDataRetrieverOptions;
import com.teamscale.service.testimpact.prioritization.ITestPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import jakarta.ws.rs.Path;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;

@Path(value="api/projects/{project}/impacted-tests")
public class ImpactedTestsService
extends TestReductionApiBase
implements ITestImpactServiceApi {
    @Override
    public List<PrioritizableTest> getImpactedTests(TiaRequestOptions tiaRequestOptions) throws StorageException, InterruptedException {
        return ImpactedTestsService.getImpactedTestsFor(tiaRequestOptions, this.serviceInfo);
    }

    private static List<PrioritizableTest> getImpactedTestsFor(TiaRequestOptions tiaRequestOptions, ITeamscaleServiceInfo serviceInfo) throws StorageException, InterruptedException {
        TiaDataRetrieverOptions tiaDataRetrieverOptions = TiaDataRetrieverOptions.create(tiaRequestOptions, serviceInfo.getInternalId(), serviceInfo.getUser(), serviceInfo.getIndexLayer());
        PrioritizableTestsRetriever prioritizableTestsRetriever = new PrioritizableTestsRetriever(tiaDataRetrieverOptions, serviceInfo.getGlobalStorageSystem(), serviceInfo.getProjectStorageSystem(), serviceInfo.getUser());
        TestDataRetriever dataRetriever = new TestDataRetriever(serviceInfo.getProjectStorageSystem(), tiaDataRetrieverOptions.getEndCommit(), tiaDataRetrieverOptions.tiaRequestOptions().getCoveringPath());
        ImpactedTestUtils.ensureCommitIsProcessed(serviceInfo.getProjectStorageSystem(), tiaDataRetrieverOptions);
        TestPrioritizationData testPrioritizationData = prioritizableTestsRetriever.getTestPrioritizationData();
        ITestPrioritizationStrategy prioritizationStrategy = ImpactedTestsService.initTestPrioritizationStrategy(dataRetriever, testPrioritizationData, MinimizationProgressCallback.dummy(), tiaRequestOptions.getPrioritizationStrategy());
        return prioritizationStrategy.orderTests(testPrioritizationData.getSelectedTests(), testPrioritizationData.getMethodsToTest(), tiaRequestOptions.getMaxTestSuiteRuntime());
    }

    @Override
    public List<PrioritizableTestCluster> getImpactedTestsFromAvailableTests(TiaRequestOptions tiaRequestOptions, List<TestWithClusterId> availableTests) throws StorageException, InterruptedException {
        if (availableTests.isEmpty()) {
            return Collections.emptyList();
        }
        TiaDataRetrieverOptions tiaDataRetrieverOptions = TiaDataRetrieverOptions.create(tiaRequestOptions, this.serviceInfo.getInternalId(), this.serviceInfo.getUser(), this.serviceInfo.getIndexLayer());
        PrioritizableTestsRetriever prioritizableTestsRetriever = new PrioritizableTestsRetriever(tiaDataRetrieverOptions, availableTests, this.serviceInfo.getGlobalStorageSystem(), this.serviceInfo.getProjectStorageSystem(), this.getUser());
        TestDataRetriever dataRetriever = new TestDataRetriever(this.serviceInfo.getProjectStorageSystem(), tiaDataRetrieverOptions.getEndCommit(), tiaDataRetrieverOptions.tiaRequestOptions().getCoveringPath());
        ImpactedTestUtils.ensureCommitIsProcessed(this.serviceInfo.getProjectStorageSystem(), tiaDataRetrieverOptions);
        return ImpactedTestsService.getPrioritizedTestResult(dataRetriever, prioritizableTestsRetriever, tiaRequestOptions);
    }

    private static List<PrioritizableTestCluster> getPrioritizedTestResult(TestDataRetriever dataRetriever, PrioritizableTestsRetriever prioritizableTestsRetriever, TiaRequestOptions tiaRequestOptions) throws StorageException, InterruptedException {
        TestPrioritizationData testPrioritizationData = prioritizableTestsRetriever.getTestPrioritizationData();
        ITestPrioritizationStrategy prioritizationStrategy = ImpactedTestsService.initTestPrioritizationStrategy(dataRetriever, testPrioritizationData, MinimizationProgressCallback.dummy(), tiaRequestOptions.getPrioritizationStrategy());
        return ImpactedTestsService.getTestClusters(testPrioritizationData.getTestClustersById(), testPrioritizationData, prioritizationStrategy, MinimizationProgressCallback.dummy(), tiaRequestOptions.getMaxTestSuiteRuntime());
    }
}

