/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.strategies.CoverageRoundBasedTestPrioritizationStrategyBase;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class AdditionalCoveragePerTimePrioritizationStrategy
extends CoverageRoundBasedTestPrioritizationStrategyBase {
    private static final double FACTOR_FOR_ADDITIONAL_COVERAGE = 5000.0;
    private static final double FACTOR_FOR_NON_ADDITIONAL_COVERAGE = 1.0;
    private static final int COVERAGE_CONTRIBUTION_CONSTANT = 1;
    private static final long ASSUMED_TEST_DURATION_IN_MS_IF_UNKNOWN = 10000L;
    private static final int MIN_REALISTIC_TEST_DURATION_IN_MS = 1;

    public AdditionalCoveragePerTimePrioritizationStrategy(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    @Override
    protected <T extends IPrioritizableTests> double computeCurrentTestScore(T test) {
        return AdditionalCoveragePerTimePrioritizationStrategy.computeCoveragePerTimeUnit(test.getDurationInMs(10000L), test.getNumberOfCurrentAdditionallyCoveredMethods(), test.getNumberOfCoveredMethods());
    }

    protected static double computeCoveragePerTimeUnit(double testDurationInMs, double currentAdditionalCoveredMethodsWeight, double allCoveredMethodsWeight) {
        CCSMAssert.isTrue((currentAdditionalCoveredMethodsWeight <= allCoveredMethodsWeight ? 1 : 0) != 0, (String)"Invalid method weights");
        double otherCoveredMethodWeight = allCoveredMethodsWeight - currentAdditionalCoveredMethodsWeight;
        double coverageContribution = 5000.0 * currentAdditionalCoveredMethodsWeight + 1.0 * otherCoveredMethodWeight + 1.0;
        double durationInMs = Math.max(1.0, testDurationInMs);
        return coverageContribution / durationInMs;
    }
}

