/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.tests.TestHistoryByPartitionDelegateIndex;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.issues.QueryServiceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TestQueryUtils {
    public static List<TestHistoryEntry> getTestHistoryEntries(@Nullable String query, boolean onlyWithCoverage, boolean onPartitionLevel, CommitDescriptor resolvedCommit, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        List<TestHistoryEntry> testHistoryEntries;
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        TestHistoryIndex testHistoryIndex = (TestHistoryIndex)serviceInfo.getProjectStorageSystem().openProjectIndex(TestHistoryIndex.class, historyAccessOption);
        Object indexToQueryOn = onPartitionLevel ? new TestHistoryByPartitionDelegateIndex(testHistoryIndex) : testHistoryIndex;
        if (StringUtils.isEmpty((String)query)) {
            testHistoryEntries = indexToQueryOn.getAllObjects();
        } else {
            List<String> tests = QueryServiceBase.performQueryWithErrorHandling(query, indexToQueryOn, historyAccessOption, StoredQueryIndex.EStoredQueryType.TEST, serviceInfo);
            testHistoryEntries = indexToQueryOn.getByIds(tests).stream().filter(Objects::nonNull).toList();
        }
        if (onlyWithCoverage) {
            testHistoryEntries = TestQueryUtils.filterTestsWithoutCoverage(historyAccessOption, testHistoryEntries, serviceInfo);
        }
        return testHistoryEntries;
    }

    private static List<TestHistoryEntry> filterTestsWithoutCoverage(HistoryAccessOption historyAccessOption, List<TestHistoryEntry> testHistoryEntries, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        ArrayList<PartitionAndPath> tests = new ArrayList<PartitionAndPath>();
        HashMap<String, TestHistoryEntry> uniformPathToTestEntry = new HashMap<String, TestHistoryEntry>();
        for (TestHistoryEntry testHistoryEntry : testHistoryEntries) {
            uniformPathToTestEntry.put(testHistoryEntry.getUniformPath(), testHistoryEntry);
            for (String partition : testHistoryEntry.getPartitions()) {
                tests.add(new PartitionAndPath(partition, testHistoryEntry.getUniformPath()));
            }
        }
        CoverageUnitToMethodsMapIndex coverageUnitToMethodsMapIndex = (CoverageUnitToMethodsMapIndex)serviceInfo.getProjectStorageSystem().openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        List testsWithCoverage = coverageUnitToMethodsMapIndex.getTestsWithCoverage(tests);
        ArrayList<TestHistoryEntry> result = new ArrayList<TestHistoryEntry>();
        CollectionUtils.forEach(tests, (Iterable)testsWithCoverage, (test, hasCoverage) -> {
            TestHistoryEntry testHistoryEntry;
            if (hasCoverage.booleanValue() && (testHistoryEntry = (TestHistoryEntry)uniformPathToTestEntry.remove(test.getUniformPath())) != null) {
                result.add(testHistoryEntry);
            }
        });
        return result;
    }

    private TestQueryUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

