/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Only used as DTO")
@Schema(allOf={MethodBasedTreeMapNodeBase.class})
public final class CoverageMethodTreeMapNode
extends MethodBasedTreeMapNodeBase {
    @JsonProperty(value="coverableLines")
    private int coverableLines;
    @JsonProperty(value="coveredLines")
    private int coveredLines;

    public CoverageMethodTreeMapNode(String uniformPath) {
        super(uniformPath);
    }

    public CoverageMethodTreeMapNode(UniformPath uniformPath, AssociatedMethodInfo methodInfo, int coverableLines, int coveredLines, Collection<TeamscaleIssueId> matchingIssues) {
        super(uniformPath.toString(), methodInfo.getLocation().getRegion(), methodInfo.getMethodName(), matchingIssues);
        if (coverableLines < coveredLines) {
            throw new IllegalArgumentException("Encountered more covered lines (%d) than coverable lines (%d) for: %s.%s".formatted(coveredLines, coverableLines, uniformPath, methodInfo.getMethodName()));
        }
        this.coverableLines = coverableLines;
        this.coveredLines = coveredLines;
    }

    public int getCoverableLines() {
        return this.coverableLines;
    }

    public int getCoveredLines() {
        return this.coveredLines;
    }

    @JsonGetter(value="coverage")
    public double getCoverage() {
        return LineCoverageInfo.calculateCoverageRatio((int)this.coveredLines, (int)this.coverableLines);
    }

    @Override
    public void aggregateValues() {
        super.aggregateValues();
        if (this.getChildren().isEmpty()) {
            return;
        }
        this.coverableLines = this.getChildren().stream().mapToInt(child -> ((CoverageMethodTreeMapNode)child).coverableLines).sum();
        this.coveredLines = this.getChildren().stream().mapToInt(child -> ((CoverageMethodTreeMapNode)child).coveredLines).sum();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }
}

