/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user.notifications;

import com.teamscale.index.notifications.metrics.MetricNotificationRuleIndex;
import com.teamscale.index.notifications.metrics.MetricNotificationRules;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.io.Serializable;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/notification-rules/metric")
public class MetricNotificationRuleService
extends ApiBase {
    @GET
    @Operation(summary="Get metric notification rules", description="Retrieves the currently set metric notification rules for the current user", tags={"Users"})
    @RequiresNoPermission
    public MetricNotificationRules getMetricNotificationRules() throws StorageException {
        MetricNotificationRules notificationRules = (MetricNotificationRules)this.openGlobalIndex(MetricNotificationRuleIndex.class).getNotificationRules(this.getUser().getUsername());
        if (notificationRules == null) {
            return new MetricNotificationRules();
        }
        return notificationRules;
    }

    @PUT
    @Operation(summary="Set metric notification rules", description="Edits the currently set metric notification rules for the current user", tags={"Users"})
    @RequiresNoPermission
    public void setMetricNotificationRules(@RequestBody MetricNotificationRules notificationRules) throws StorageException {
        this.openGlobalIndex(MetricNotificationRuleIndex.class).setNotificationRules(this.getUser().getUsername(), (Serializable)notificationRules);
    }
}

