/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.teamscale.index.admin.instance_comparison.comparison.GlobalComparisonResult;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationMetadata;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonResultBase;
import com.teamscale.index.admin.instance_comparison.comparison.ProjectComparisonResult;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.TestOnly;

@Index(name="instance-comparison-computation", options={EStorageOption.COMPRESSED})
public class InstanceComparisonComputationIndex
implements IGlobalIndex {
    public static final String NAME = "instance-comparison-computation";
    private final ValueIndex<InstanceComparisonComputationMetadata> metadataIndex;
    @Deprecated
    private final ValueIndex<InstanceComparisonResultBase> oldResultIndex;
    private final Function<String, SplittingResultIndex> resultIndex;

    public InstanceComparisonComputationIndex(IStore store) {
        this.metadataIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "m"));
        this.oldResultIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "r"));
        this.resultIndex = prefix -> new SplittingResultIndex((IStore)new DelegatingPartitionStore(store, "r2"), (String)prefix);
    }

    public void addComparison(String snapshotId, InstanceComparisonComputationMetadata comparison) throws StorageException {
        this.updateComparisonMetadata(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, comparison.getId()), comparison);
    }

    public void removeComparison(String snapshotId, String comparisonId) throws StorageException {
        this.metadataIndex.removeValue(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, comparisonId));
        String resultKey = InstanceComparisonComputationIndex.makeComparisonResultKey(snapshotId, comparisonId, null, null);
        this.oldResultIndex.removeEntriesStartingWith(List.of(resultKey));
        this.resultIndex.apply(resultKey).clear();
    }

    public Optional<InstanceComparisonComputationMetadata> getComparisonMetadata(String snapshotId, String comparisonId) throws StorageException {
        return this.getComparisonMetadata(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, comparisonId));
    }

    Optional<InstanceComparisonComputationMetadata> getComparisonMetadata(String combinedKey) throws StorageException {
        return Optional.ofNullable((InstanceComparisonComputationMetadata)this.metadataIndex.getValue(combinedKey));
    }

    void updateComparisonMetadata(String combinedKey, InstanceComparisonComputationMetadata comparisonMetadata) throws StorageException {
        this.metadataIndex.runLocked(combinedKey, () -> this.metadataIndex.setValue(combinedKey, (Object)comparisonMetadata));
    }

    public List<InstanceComparisonComputationMetadata> getReferencedComparisons(String snapshotId) throws StorageException {
        return this.metadataIndex.getEntriesStartingWith(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, null)).getSecondList();
    }

    public void removeAllComparisons(String snapshotId) throws StorageException {
        this.metadataIndex.removeEntriesStartingWith(List.of(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, null)));
        String resultKey = InstanceComparisonComputationIndex.makeComparisonResultKey(snapshotId, null, null, null);
        this.oldResultIndex.removeEntriesStartingWith(List.of(resultKey));
        this.resultIndex.apply(resultKey).clear();
    }

    public static String makeSnapshotToComparisonKey(String snapshotId, @Nullable String comparisonId) {
        String prefix = "s" + snapshotId + "|";
        if (comparisonId == null) {
            return prefix;
        }
        return prefix + comparisonId;
    }

    private static String makeComparisonResultKey(String snapshotId, @Nullable String comparisonId, @Nullable String projectId, @Nullable String contributor) {
        CCSMAssert.isNotNull((Object)snapshotId, () -> String.format("Expected \"%s\" to be not null", "snapshotId"));
        if (comparisonId == null) {
            CCSMAssert.isTrue((projectId == null ? 1 : 0) != 0, () -> String.format("Expected \"%s\" to be null when \"%s\" is null", "projectId", "comparisonId"));
        }
        if (projectId == null) {
            CCSMAssert.isTrue((contributor == null ? 1 : 0) != 0, () -> String.format("Expected \"%s\" to be null when \"%s\" is null", "contributor", "projectId"));
        }
        return Stream.of(snapshotId, comparisonId, projectId, contributor).takeWhile(Objects::nonNull).collect(Collectors.joining("|")) + "|";
    }

    void addResult(InstanceComparisonComputationMetadata comparisonMetadata, InstanceComparisonResultBase result) throws StorageException {
        String snapshotId = comparisonMetadata.getOptions().getLocalSnapshotId();
        String comparisonId = comparisonMetadata.getId();
        this.resultIndex.apply(InstanceComparisonComputationIndex.makeComparisonResultKey(snapshotId, comparisonId, result.getProject(), result.getContributor())).storeResult(result);
        comparisonMetadata.registerResult(result);
        this.updateComparisonMetadata(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, comparisonId), comparisonMetadata);
    }

    @TestOnly
    void addOutdatedResult(InstanceComparisonComputationMetadata comparisonMetadata, InstanceComparisonResultBase result) throws StorageException {
        String snapshotId = comparisonMetadata.getOptions().getLocalSnapshotId();
        String comparisonId = comparisonMetadata.getId();
        this.oldResultIndex.setValue(InstanceComparisonComputationIndex.makeComparisonResultKey(snapshotId, comparisonId, result.getProject(), result.getContributor()), (Object)result);
        comparisonMetadata.registerResult(result);
        this.updateComparisonMetadata(InstanceComparisonComputationIndex.makeSnapshotToComparisonKey(snapshotId, comparisonId), comparisonMetadata);
    }

    public Optional<InstanceComparisonResultBase> getResult(String snapshotId, String comparisonId, String projectId, String contributor) throws StorageException {
        String key = InstanceComparisonComputationIndex.makeComparisonResultKey(snapshotId, comparisonId, projectId, contributor);
        InstanceComparisonResultBase value = this.resultIndex.apply(key).getResult();
        if (value == null) {
            value = (InstanceComparisonResultBase)this.oldResultIndex.getValue(key);
        }
        return Optional.ofNullable(value);
    }

    private static final class SplittingResultIndex
    implements IUtilityIndex {
        private final String keyPrefix;
        private final ValueIndex<Serializable> delegateIndex;

        public SplittingResultIndex(IStore store, String keyPrefix) {
            this.delegateIndex = ValueIndex.forSerializable((IStore)store);
            this.keyPrefix = keyPrefix;
        }

        private <T extends Serializable> T getValue(String key, boolean forceExistence, Class<T> type) throws StorageException {
            return (T)((Serializable)type.cast(this.delegateIndex.getValue(this.keyPrefix + key, forceExistence)));
        }

        private void setValue(String key, Serializable value) throws StorageException {
            this.delegateIndex.setValue(this.keyPrefix + key, (Object)value);
        }

        public @Nullable InstanceComparisonResultBase getResult() throws StorageException {
            String type = this.getValue("type", false, String.class);
            if (type == null) {
                return null;
            }
            String contributor = this.getValue("contributor", true, String.class);
            List<InstanceComparisonDiffEntryBase<?>> onlyInLocal = this.loadDiffs("local");
            List<InstanceComparisonDiffEntryBase<?>> onlyInRemote = this.loadDiffs("remote");
            List<InstanceComparisonDiffEntryBase<?>> differences = this.loadDiffs("diff");
            return switch (type) {
                case "project" -> {
                    String project = this.getValue("project", true, String.class);
                    yield new ProjectComparisonResult(contributor, project, onlyInLocal, onlyInRemote, differences);
                }
                case "global" -> new GlobalComparisonResult(contributor, onlyInLocal, onlyInRemote, differences);
                default -> throw new UnsupportedOperationException("Unsupported type: " + type);
            };
        }

        public void storeResult(InstanceComparisonResultBase result) throws StorageException {
            InstanceComparisonResultBase instanceComparisonResultBase = result;
            Objects.requireNonNull(instanceComparisonResultBase);
            InstanceComparisonResultBase instanceComparisonResultBase2 = instanceComparisonResultBase;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProjectComparisonResult.class, GlobalComparisonResult.class}, (Object)instanceComparisonResultBase2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ProjectComparisonResult projectComparisonResult = (ProjectComparisonResult)instanceComparisonResultBase2;
                    this.setValue("type", (Serializable)((Object)"project"));
                    this.setValue("project", (Serializable)((Object)projectComparisonResult.getProject()));
                    break;
                }
                case 1: {
                    GlobalComparisonResult ignored = (GlobalComparisonResult)instanceComparisonResultBase2;
                    this.setValue("type", (Serializable)((Object)"global"));
                }
            }
            this.setValue("contributor", (Serializable)((Object)result.getContributor()));
            this.putDiffs("local", result.getOnlyInLocalInstance());
            this.putDiffs("remote", result.getOnlyInRemoteInstance());
            this.putDiffs("diff", result.getDiffs());
        }

        private List<InstanceComparisonDiffEntryBase<?>> loadDiffs(String prefix) throws StorageException {
            int size = this.getValue(prefix + "size", true, Integer.class);
            ArrayList diffs = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                diffs.add(this.getValue(prefix + "diff" + i, true, InstanceComparisonDiffEntryBase.class));
            }
            return diffs;
        }

        private void putDiffs(String prefix, List<InstanceComparisonDiffEntryBase<?>> diffs) throws StorageException {
            this.setValue(prefix + "size", Integer.valueOf(diffs.size()));
            int index = 0;
            for (InstanceComparisonDiffEntryBase<?> diff : diffs) {
                this.setValue(prefix + "diff" + index++, diff);
            }
        }

        public void clear() throws StorageException {
            this.delegateIndex.removeEntriesStartingWith(List.of(this.keyPrefix));
        }

        public IStore getWrappedStore() {
            return this.delegateIndex.getWrappedStore();
        }
    }
}

