/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import com.teamscale.index.migration.finding.GlobalOptionReplacement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public class MigrationChanges
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TwoDimHashMap<String, String, ConfigurationOptionReplacement> renamesByGroupAndOptionName = new TwoDimHashMap();
    private final TwoDimHashMap<String, String, GlobalOptionReplacement> renamedGlobalOptions = new TwoDimHashMap();
    private final List<Pair<String, String>> groupsWithDeletedOptions = new ArrayList<Pair<String, String>>();
    private final Set<String> globalOptionDeletions = new HashSet<String>();

    private MigrationChanges(TwoDimHashMap<String, String, ConfigurationOptionReplacement> renamesByGroupAndNewOptionName, List<Pair<String, String>> groupsWithDeletedOptions, Set<String> globalOptionDeletions) {
        this.renamesByGroupAndOptionName.putAll(renamesByGroupAndNewOptionName);
        this.globalOptionDeletions.addAll(globalOptionDeletions);
        this.groupsWithDeletedOptions.addAll(groupsWithDeletedOptions);
    }

    public static MigrationChanges create() {
        return new MigrationChanges((TwoDimHashMap<String, String, ConfigurationOptionReplacement>)new TwoDimHashMap(), new ArrayList<Pair<String, String>>(), new HashSet<String>());
    }

    public TwoDimHashMap<String, String, ConfigurationOptionReplacement> getRenamesByGroupAndOptionName() {
        return this.renamesByGroupAndOptionName;
    }

    public Set<String> getDeletedOptions() {
        return CollectionUtils.asUnmodifiable(this.globalOptionDeletions);
    }

    public Set<String> getGlobalOptionDeletions() {
        return this.globalOptionDeletions;
    }

    public List<Pair<String, String>> getGroupsWithDeletedOptions() {
        return CollectionUtils.asUnmodifiable(this.groupsWithDeletedOptions);
    }

    public boolean isEmpty() {
        return this.renamesByGroupAndOptionName.isEmpty() && this.globalOptionDeletions.isEmpty() && this.groupsWithDeletedOptions.isEmpty() && this.renamedGlobalOptions.isEmpty();
    }

    public MigrationChanges addConfigurationOptionRename(ConfigurationOptionReplacement replacement) {
        this.renamesByGroupAndOptionName.putValue((Object)replacement.getOldGroupName(), (Object)replacement.getOldOptionName(), (Object)replacement);
        return this;
    }

    public MigrationChanges addGlobalOptionReplacement(GlobalOptionReplacement globalOptionReplacement) {
        this.renamedGlobalOptions.putValue((Object)globalOptionReplacement.getOldOptionName(), (Object)globalOptionReplacement.getNewOptionName(), (Object)globalOptionReplacement);
        return this;
    }

    public MigrationChanges addOptionDeletion(String oldGroupName, String oldOptionName) {
        this.groupsWithDeletedOptions.add((Pair<String, String>)Pair.createPair((Object)oldGroupName, (Object)oldOptionName));
        return this;
    }

    public MigrationChanges addGlobalOptionDeletion(String optionName) {
        this.globalOptionDeletions.add(optionName);
        return this;
    }

    public TwoDimHashMap<String, String, GlobalOptionReplacement> getRenamedGlobalOptions() {
        return this.renamedGlobalOptions;
    }

    public void addChanges(MigrationChanges otherChanges) {
        this.renamesByGroupAndOptionName.putAll(otherChanges.renamesByGroupAndOptionName);
        this.globalOptionDeletions.addAll(otherChanges.globalOptionDeletions);
        this.groupsWithDeletedOptions.addAll(otherChanges.groupsWithDeletedOptions);
        this.renamedGlobalOptions.putAll(otherChanges.renamedGlobalOptions);
    }
}

