/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ArchitectureMetricsMappingIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureAssessmentIndex architectureAssessmentIndex;
    @DeltaSource(value=ArchitectureAssessmentIndex.class)
    private KeyDelta architectureAssessmentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;

    public void execute() throws StorageException {
        try {
            this.metricsToArchitectureMetricsIndex.removeArchitectureMetricData(this.architectureAssessmentDelta.getDeletedKeysAsStrings());
            this.recalculateArchitectureMappings(this.architectureAssessmentDelta.getAddedOrChangedKeysAsStrings());
        }
        catch (ConQATException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void recalculateArchitectureMappings(List<String> addedOrChangedAssessments) throws ConQATException {
        for (String changedPath : addedOrChangedAssessments) {
            String pathWithoutFilename = UniformPathUtils.concatenate((String[])new String[]{ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES, UniformPathUtils.getParentPath((String)changedPath)});
            List<String> oldMappings = this.metricsToArchitectureMetricsIndex.getAllMappingsForArchitecture(changedPath);
            ArchitectureAssessmentInfo assessment = this.architectureAssessmentIndex.getAssessment(changedPath);
            if (assessment == null) {
                LOGGER.error("Assessment was null for changed path '" + changedPath + "'. Skipping.");
                continue;
            }
            Collection<String> newMappings = this.calculateMappedPaths(assessment.getRoot(), pathWithoutFilename, !assessment.fileBased);
            HashSet mappingToUpdate = CollectionUtils.differenceSet(newMappings, (Collection[])new Collection[]{oldMappings});
            HashSet mappingsToRemove = CollectionUtils.differenceSet(oldMappings, (Collection[])new Collection[]{newMappings});
            this.metricsToArchitectureMetricsIndex.removeMappings(new ArrayList<String>(mappingsToRemove));
            this.metricsToArchitectureMetricsIndex.setMappedPaths(new ArrayList<String>(mappingToUpdate));
        }
    }

    private Collection<String> calculateMappedPaths(ArchitectureComponentInfo architectureComponent, String currentPath, boolean isTypeBased) throws StorageException {
        currentPath = (String)currentPath + "/" + StringUtils.getLastPart((String)architectureComponent.name, (char)'/');
        Object matchedFiles = architectureComponent.getMatchedTypes().keySet();
        matchedFiles = isTypeBased ? this.lookupFilesForTypes((Collection<String>)matchedFiles) : this.removeThirdPartyTypes((Collection<String>)matchedFiles);
        HashSet<String> mappedPaths = new HashSet<String>();
        mappedPaths.addAll(MetricsToArchitectureMetricsMappingIndex.createMappings((String)currentPath, (Collection<String>)matchedFiles));
        for (ArchitectureComponentInfo subComponent : architectureComponent.getSubComponents()) {
            mappedPaths.addAll(this.calculateMappedPaths(subComponent, (String)currentPath, isTypeBased));
        }
        if (mappedPaths.isEmpty()) {
            mappedPaths.addAll(MetricsToArchitectureMetricsMappingIndex.createMappings((String)currentPath, Arrays.asList("--NO_MAPPING--")));
        }
        return mappedPaths;
    }

    private Collection<String> removeThirdPartyTypes(Collection<String> matchedFiles) throws StorageException {
        return this.typeIndex.getExistingFiles(new ArrayList<String>(matchedFiles));
    }

    private Collection<String> lookupFilesForTypes(Collection<String> matchedTypes) throws StorageException {
        if (matchedTypes.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        HashSet<String> files = new HashSet<String>();
        List<List<String>> filesForTypes = this.typeIndex.getFilesForTypes(matchedTypes);
        for (List<String> fileList : filesForTypes) {
            files.addAll(fileList);
        }
        if (files.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return files;
    }
}

