/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.external;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="architecture-upload-state", options={EStorageOption.COMPRESSED}, valueClasses={EArchitectureUploadType.class})
public class ArchitectureUploadAnalysisStateIndex
implements IProjectIndex,
IRollbackableIndex {
    private static final String KEY_DELIMITER = "#-#";
    public static final String INDEX_NAME = "architecture-upload-state";
    private final ValueIndex<EArchitectureUploadType> delegate;

    public ArchitectureUploadAnalysisStateIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setArchitectureUpload(String uniformPath, CommitDescriptor commit, EArchitectureUploadType value) throws StorageException {
        this.delegate.setValue(ArchitectureUploadAnalysisStateIndex.createKey(uniformPath, commit), (Object)value);
    }

    public static Pair<String, CommitDescriptor> splitKey(String key) {
        String[] parts = StringUtils.splitByWholeSeparator((String)key, (String)KEY_DELIMITER);
        return new Pair((Object)parts[1], (Object)new CommitDescriptor(parts[0], Long.parseLong(parts[2])));
    }

    private static String createKey(String uniformPath, CommitDescriptor commit) {
        return commit.getBranchName() + KEY_DELIMITER + uniformPath + KEY_DELIMITER + commit.getTimestamp();
    }

    public PairList<String, EArchitectureUploadType> getAllUploadsForBranch(String branch) throws StorageException {
        return this.delegate.getEntriesStartingWith(branch + KEY_DELIMITER);
    }

    public void removeAllEntriesBeforeOrAt(CommitDescriptor commit) throws StorageException {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Pair entry : this.delegate.getEntriesStartingWith(commit.getBranchName() + KEY_DELIMITER)) {
            Pair<String, CommitDescriptor> keyComponents = ArchitectureUploadAnalysisStateIndex.splitKey((String)entry.getFirst());
            if (((CommitDescriptor)keyComponents.getSecond()).getTimestamp() > commit.getTimestamp()) continue;
            toRemove.add((String)entry.getFirst());
        }
        this.delegate.removeValues(toRemove);
    }

    public void rollbackTo(String branch, long timestamp) throws StorageException {
        List keys = this.delegate.getAllKeys();
        ArrayList<String> keysToBeRemoved = new ArrayList<String>();
        for (String key : keys) {
            CommitDescriptor keyCommit = (CommitDescriptor)ArchitectureUploadAnalysisStateIndex.splitKey(key).getSecond();
            if (keyCommit.getTimestamp() <= timestamp || !keyCommit.getBranchName().equals(branch)) continue;
            keysToBeRemoved.add(key);
        }
        this.delegate.removeValues(keysToBeRemoved);
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            this.rollbackTo(entry.getKey(), entry.getValue());
        }
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EArchitectureUploadType {
        ADD,
        DELETE;

    }
}

