/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

class ArchitectureComponentMapper {
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final Set<String> knownTypes;
    private final PairList<String, ArrayList<TypeDependencies>> dependencies;
    private final TypeDependencyIndex typeDependencyIndex;

    ArchitectureComponentMapper(TypeDependencyIndex typeDependencyIndex, TypeIndex typeIndex, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.knownTypes = typeIndex.getAllTypeNames();
        this.dependencies = typeDependencyIndex.getAllTypeDependencies();
        this.typeDependencyIndex = typeDependencyIndex;
    }

    public Pair<String, TypeComponentMapping> createComponentMapping(TokenElementInfo architecture) throws ConQATException {
        ArchitectureDefinition architectureDefinition = ArchitectureAnalysisUtils.getArchitectureDefinition(architecture);
        List<String> files = this.getFiles(this.knownTypes);
        List<String> input = architectureDefinition.isFileBased() ? files : this.getTypes();
        TypeToComponentMapper typeToComponentMapper = new TypeToComponentMapper(architectureDefinition, this.parallelTaskExecutor);
        TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(input);
        TypeComponentMapping metaInfo = new TypeComponentMapping(mappingResult);
        for (String type : files) {
            List<String> thirdPartyTypes = this.getThirdPartyDependencies(type, this.typeDependencyIndex);
            metaInfo.addThirdPartyDependency(thirdPartyTypes);
        }
        return Pair.createPair((Object)architectureDefinition.getName(), (Object)metaInfo);
    }

    private List<String> getThirdPartyDependencies(String type, TypeDependencyIndex typeDependencyIndex) throws StorageException {
        List<TypeDependencies> typeDependencies = typeDependencyIndex.getTypeDependencies(type);
        if (typeDependencies == null) {
            return Collections.emptyList();
        }
        return typeDependencies.stream().map(TypeDependencies::getDependencies).flatMap(Collection::stream).filter(t -> !this.knownTypes.contains(t)).toList();
    }

    private List<String> getFiles(Set<String> knownTypes) throws StorageException {
        ArrayList<String> types = new ArrayList<String>(this.dependencies.extractFirstList());
        this.dependencies.extractSecondList().stream().flatMap(Collection::stream).flatMap(t -> t.getDependencies().stream()).filter(type -> !knownTypes.contains(type)).forEach(types::add);
        return types;
    }

    private List<String> getTypes() throws StorageException {
        ArrayList<String> types = new ArrayList<String>();
        for (ArrayList typeDependenciesPerType : this.dependencies.extractSecondList()) {
            types.addAll(typeDependenciesPerType.stream().map(TypeDependencies::getType).toList());
            ArchitectureComponentMapper.addTypesFromDependencyLocations(typeDependenciesPerType, types);
        }
        return types;
    }

    private static void addTypesFromDependencyLocations(List<TypeDependencies> typeDependenciesPerType, List<String> types) {
        for (TypeDependencies typeDependencies : typeDependenciesPerType) {
            UnmodifiableSet<String> dependencyLocations = typeDependencies.getDependencies();
            types.addAll((Collection<String>)dependencyLocations);
        }
    }
}

