/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.s3;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.ReadCachedBackupTargetBase;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.S3ClientFactory;
import com.teamscale.index.s3.S3Exception;
import com.teamscale.index.s3.S3UriParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.ByteUnit;

public class S3BackupTarget
extends ReadCachedBackupTargetBase {
    private static final int CHUNK_SIZE = (int)ByteUnit.MEBIBYTES.toBytes(15L);
    private final IS3Client s3;
    private final String bucket;
    private final String key;

    public S3BackupTarget(URI uri, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException {
        S3UriParser.ParsedUri parsedUri = S3UriParser.parseUri(uri);
        this.bucket = parsedUri.getBucket();
        this.key = parsedUri.getKey();
        this.s3 = new S3ClientFactory().createForUri((IExternalCredentialsProvider)externalCredentialsIndex, parsedUri);
    }

    @Override
    public String validate() {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream s3MultiPartStream;
        try {
            s3MultiPartStream = this.s3.initiateMultipartUpload(this.bucket, this.key);
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
        return new FilterOutputStream(this, new BufferedOutputStream(s3MultiPartStream, CHUNK_SIZE)){

            @Override
            public void flush() {
            }

            @Override
            public void close() throws IOException {
                try {
                    this.out.flush();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void deleteBackupFile() throws IOException {
        try {
            this.s3.deleteObject(this.bucket, this.key);
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo backupLocationInfo) throws IOException {
        String backupIdentifierPrefix = backupLocationInfo.getBackupIdentifierPrefix();
        String filenamePrefix = backupIdentifierPrefix.substring(backupIdentifierPrefix.lastIndexOf(this.bucket) + this.bucket.length() + 1);
        try {
            return this.s3.listObjects(this.bucket, filenamePrefix).stream().map(summary -> new BackupInfo(summary.key(), summary.lastModified().getTime())).filter(backupLocationInfo::hasSameSuffixAsCurrentTeamscaleInstance).collect(Collectors.toList());
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteBackupsInSameLocation(List<BackupInfo> backupInfos) throws IOException {
        try {
            this.s3.deleteObjects(this.bucket, backupInfos.stream().map(BackupInfo::getBackupIdentifier));
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeToTemporaryFile(File temporaryFile) throws IOException {
        try {
            this.s3.writeObjectToFile(this.bucket, this.key, temporaryFile);
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }
}

