/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.refactoring_detection.TypeAwareTokenListIterator;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;

public class ParallelTokenListIterator {
    private final TypeAwareTokenListIterator oldTokenListIterator;
    private final TypeAwareTokenListIterator newTokenListIterator;

    public ParallelTokenListIterator(List<IToken> oldTokens, ScopedTypeLookup oldTypeLookup, List<IToken> newTokens, ScopedTypeLookup newTypeLookup) {
        this.oldTokenListIterator = new TypeAwareTokenListIterator(oldTokens, oldTypeLookup);
        this.newTokenListIterator = new TypeAwareTokenListIterator(newTokens, newTypeLookup);
    }

    public TypeAwareTokenListIterator getOldTokenListIterator() {
        return this.oldTokenListIterator;
    }

    public TypeAwareTokenListIterator getNewTokenListIterator() {
        return this.newTokenListIterator;
    }

    public void reset() {
        this.oldTokenListIterator.setTokenPos(0);
        this.newTokenListIterator.setTokenPos(0);
    }

    public boolean next() {
        if (this.hasMoreTokens()) {
            this.oldTokenListIterator.incTokenPos(1);
            this.newTokenListIterator.incTokenPos(1);
        }
        return this.hasMoreTokens();
    }

    public String getOldTokenText() {
        return this.oldTokenListIterator.getCurrentToken().getText();
    }

    public String getNewTokenText() {
        return this.newTokenListIterator.getCurrentToken().getText();
    }

    public boolean bothAreAnyOfType(Set<ETokenType> tokenTypes) {
        return this.newTokenListIterator.isOfAnyType(0, tokenTypes) && this.oldTokenListIterator.getCurrentToken().getType() == this.newTokenListIterator.getCurrentToken().getType();
    }

    public boolean bothMatchTypeSequence(int offset, ETokenType ... tokenTypes) {
        return this.oldTokenListIterator.isOfType(offset, tokenTypes) && this.newTokenListIterator.isOfType(offset, tokenTypes);
    }

    public boolean bothMatchTypePattern(int offset, TokenTypePattern pattern) {
        return this.oldTokenListIterator.matchesFollowing(offset, pattern) && this.newTokenListIterator.matchesFollowing(offset, pattern);
    }

    public boolean hasMoreTokens() {
        return this.oldTokenListIterator.hasCurrentToken() && this.newTokenListIterator.hasCurrentToken();
    }

    public TypedVariable getOldTypeInfo(String variableName) {
        return this.oldTokenListIterator.getTypeInfo(variableName);
    }

    public TypedVariable getNewTypeInfo(String variableName) {
        return this.newTokenListIterator.getTypeInfo(variableName);
    }

    public boolean tokenNameAndTypesEqual() {
        return this.oldTokenListIterator.currentTokenNameAndTypesEqual(this.newTokenListIterator);
    }

    public boolean bothEndsReached() {
        return !this.oldTokenListIterator.hasCurrentToken() && !this.newTokenListIterator.hasCurrentToken();
    }

    public boolean oldEquals(List<IToken> subList) {
        boolean contains = this.oldTokenListIterator.isSubList(subList);
        if (contains) {
            this.oldTokenListIterator.incTokenPos(subList.size() - 1);
        }
        return contains;
    }

    public boolean newEquals(List<IToken> subList) {
        boolean contains = this.newTokenListIterator.isSubList(subList);
        if (contains) {
            this.newTokenListIterator.incTokenPos(subList.size() - 1);
        }
        return contains;
    }

    public boolean skipIfMatchesInAnyDirection(TokenTypePattern tokenTypePattern1, TokenTypePattern tokenTypePattern2) {
        boolean oldMatchesPattern1 = this.oldTokenListIterator.matchesFollowing(tokenTypePattern1);
        boolean oldMatchesPattern2 = this.oldTokenListIterator.matchesFollowing(tokenTypePattern2);
        boolean newMatchesPattern1 = this.newTokenListIterator.matchesFollowing(tokenTypePattern1);
        boolean newMatchesPattern2 = this.newTokenListIterator.matchesFollowing(tokenTypePattern2);
        if (oldMatchesPattern1 && newMatchesPattern2) {
            this.oldTokenListIterator.skip(tokenTypePattern1);
            this.newTokenListIterator.skip(tokenTypePattern2);
            return true;
        }
        if (oldMatchesPattern2 && newMatchesPattern1) {
            this.oldTokenListIterator.skip(tokenTypePattern2);
            this.newTokenListIterator.skip(tokenTypePattern1);
            return true;
        }
        return false;
    }

    public boolean skipIfMatchesInAnyDirection(ETokenType ... sequence) {
        boolean oldMatchesPattern1 = this.oldTokenListIterator.isOfType(0, sequence);
        boolean newMatchesPattern1 = this.newTokenListIterator.isOfType(0, sequence);
        if (oldMatchesPattern1 && !newMatchesPattern1) {
            this.oldTokenListIterator.incTokenPos(sequence.length);
            return true;
        }
        if (!oldMatchesPattern1 && newMatchesPattern1) {
            this.newTokenListIterator.incTokenPos(sequence.length);
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.oldTokenListIterator) + "\n" + String.valueOf(this.newTokenListIterator);
    }

    public boolean skipFirstIfTypeAnyOf(Set<ETokenType> tokenTypes) {
        boolean skipped = false;
        boolean oldMatchesPattern = this.oldTokenListIterator.isOfAnyType(0, tokenTypes);
        boolean newMatchesPattern = this.newTokenListIterator.isOfAnyType(0, tokenTypes);
        if (oldMatchesPattern) {
            this.oldTokenListIterator.incTokenPos(1);
            skipped = true;
        }
        if (newMatchesPattern) {
            this.newTokenListIterator.incTokenPos(1);
            skipped = true;
        }
        return skipped;
    }
}

