/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.MethodMatchRegion;
import com.teamscale.index.code_change.refactoring_detection.IMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.IRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.IRegionRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.RefactoringDetectorStrategyFactory;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class RefactoringDetector {
    private final long timestamp;
    private final RenameDetector renameDetector;
    private final PairList<MatchRegion, MatchRegion> changedRegions;
    private Map<ELanguage, IRefactoringDetectorStrategy<? extends MatchRegion>> refactoringDetectorCache = new HashMap<ELanguage, IRefactoringDetectorStrategy<? extends MatchRegion>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public RefactoringDetector(long currentAnalysisTimestamp) {
        this.timestamp = currentAnalysisTimestamp;
        this.renameDetector = new RenameDetector();
        this.changedRegions = new PairList();
    }

    public void detectRenamingsAndLoadChangedRegions(List<MatchRegion> regions) {
        boolean newRenamingsDetected = this.renameDetector.detectRenames(regions);
        if (newRenamingsDetected) {
            regions.addAll(this.popAllChangedRegions());
        }
    }

    public void markIfRefactoredAndSetLastChangeTimestamp(List<MatchRegion> newRegions) {
        for (MatchRegion newRegion : newRegions) {
            if (!newRegion.isMatched()) continue;
            try {
                long changeTimestamp;
                if (this.isChangedRegion(newRegion, newRegions)) {
                    changeTimestamp = this.timestamp;
                    this.changedRegions.add((Object)newRegion.getMatch(), (Object)newRegion);
                } else {
                    changeTimestamp = newRegion.getLastChangeTimestampOfMatch();
                }
                newRegion.setLastChangeTimestamp(changeTimestamp);
            }
            catch (Exception e) {
                LOGGER.error("Error during refactoring detection, skipping region '" + String.valueOf((Object)newRegion) + "'", (Throwable)e);
            }
        }
    }

    private List<MatchRegion> popAllChangedRegions() {
        ArrayList<MatchRegion> list = new ArrayList<MatchRegion>();
        for (int i = 0; i < this.changedRegions.size(); ++i) {
            MatchRegion newRegion = (MatchRegion)((Object)this.changedRegions.getSecond(i));
            list.add(newRegion);
        }
        this.changedRegions.clear();
        return list;
    }

    private boolean isChangedRegion(MatchRegion region, List<MatchRegion> allNewRegionsInCommit) {
        IRefactoringDetectorStrategy<? extends MatchRegion> refactoringDetectorStrategy;
        CCSMAssert.isTrue((region.hasContent() && region.getMatch().hasContent() ? 1 : 0) != 0, (String)"Region must have content to investigate changes!");
        if (!RefactoringDetector.isChangedRegionHash(region)) {
            if (region instanceof MethodMatchRegion && region.getMatch() instanceof MethodMatchRegion) {
                if (!RefactoringDetector.isChangedMethodParameterHash((MethodMatchRegion)region)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((refactoringDetectorStrategy = this.getRefactorDetectionStrategy(region.getContent().getLanguage(), allNewRegionsInCommit)) instanceof IMethodRefactoringDetectorStrategy) {
            return !((IMethodRefactoringDetectorStrategy)refactoringDetectorStrategy).containsRefactoringsOnly((MethodMatchRegion)region);
        }
        if (refactoringDetectorStrategy instanceof IRegionRefactoringDetectorStrategy) {
            return !((IRegionRefactoringDetectorStrategy)refactoringDetectorStrategy).containsRefactoringsOnly(region);
        }
        CCSMAssert.fail((String)"Unknown implementation of IRefactoringDetectorStrategy!");
        return false;
    }

    private IRefactoringDetectorStrategy<? extends MatchRegion> getRefactorDetectionStrategy(ELanguage language, List<MatchRegion> allNewRegionsInCommit) {
        if (this.refactoringDetectorCache == null) {
            this.refactoringDetectorCache = new HashMap<ELanguage, IRefactoringDetectorStrategy<? extends MatchRegion>>();
        }
        return this.refactoringDetectorCache.computeIfAbsent(language, language1 -> this.buildRefactoringDetectorStrategy(allNewRegionsInCommit, (ELanguage)language1));
    }

    private IRefactoringDetectorStrategy<? extends MatchRegion> buildRefactoringDetectorStrategy(List<MatchRegion> allNewRegionsInCommit, ELanguage language) {
        IRefactoringDetectorStrategy<? extends MatchRegion> strategy = RefactoringDetectorStrategyFactory.createRefactoringDetectorStrategy(language, this.renameDetector);
        if (strategy instanceof IMethodRefactoringDetectorStrategy) {
            IMethodRefactoringDetectorStrategy refactoringDetectorStrategy = (IMethodRefactoringDetectorStrategy)strategy;
            ArrayList<MethodMatchRegion> newMethodRegions = new ArrayList<MethodMatchRegion>();
            allNewRegionsInCommit.stream().filter(matchedRegion -> matchedRegion instanceof MethodMatchRegion).forEach(matchedRegion -> newMethodRegions.add((MethodMatchRegion)((Object)matchedRegion)));
            refactoringDetectorStrategy.addAllMatchedMethods(newMethodRegions);
        }
        return strategy;
    }

    private static boolean isChangedMethodParameterHash(MethodMatchRegion region) {
        MethodMatchRegion match = (MethodMatchRegion)region.getMatch();
        if (RefactoringDetector.isAbapExporterUpgrade(region, match)) {
            return false;
        }
        return !region.getParameterHash().equals(match.getParameterHash());
    }

    private static boolean isAbapExporterUpgrade(MethodMatchRegion newRegion, MethodMatchRegion oldRegion) {
        if (newRegion.getLanguage() != ELanguage.ABAP) {
            return false;
        }
        ShallowEntity oldEntity = oldRegion.getContent().getEntity();
        ShallowEntity newEntity = newRegion.getContent().getEntity();
        if (!oldEntity.getSubtype().equals("function") || !newEntity.getSubtype().equals("function")) {
            return false;
        }
        UnmodifiableList oldFunctionTokens = oldRegion.getContent().getEntity().ownStartTokens();
        return TokenStreamUtils.hasTypes((List)oldFunctionTokens, (ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.IDENTIFIER, ETokenType.DOT});
    }

    private static boolean isChangedRegionHash(MatchRegion region) {
        return !region.getContentHash().equals(region.getMatch().getContentHash());
    }
}

