/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.CloneChunkIndexBase;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.code_clones.normalization.FastUnifiedNormalization;
import com.teamscale.index.resource.TokenElementInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;

@Index(name="clone-chunks-by-path", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={CloneChunk.class})
public class CloneChunkByPathIndex
extends CloneChunkIndexBase
implements IProjectIndex {
    public static final XXHashFactory HASH_FACTORY = XXHashFactory.fastestInstance();
    public static final String INDEX_NAME = "clone-chunks-by-path";
    private static final byte[] CHUNK_SIZE_KEY = ByteArrayUtils.intToByteArray((int)-1);
    private static final byte[] UNIT_SEPARATOR = "*#*".getBytes(StandardCharsets.UTF_8);
    private int cachedChunkLength = 0;

    public CloneChunkByPathIndex(IStore store) {
        super(store);
    }

    public int getChunkLength() throws StorageException {
        if (this.cachedChunkLength <= 0) {
            byte[] value = this.store.get(CHUNK_SIZE_KEY);
            if (value == null) {
                return 0;
            }
            this.cachedChunkLength = ByteArrayUtils.byteArrayToInt((byte[])value);
        }
        return this.cachedChunkLength;
    }

    public void setChunkLength(int chunkLength) throws StorageException {
        CCSMAssert.isTrue((chunkLength > 0 ? 1 : 0) != 0, (String)"Chunk length must be positive!");
        this.store.put(CHUNK_SIZE_KEY, ByteArrayUtils.intToByteArray((int)chunkLength));
        this.cachedChunkLength = chunkLength;
    }

    public List<CloneChunkList> getChunksForElements(@NonNull List<String> paths) throws StorageException {
        ArrayList<CloneChunkList> result = new ArrayList<CloneChunkList>(paths.size());
        List values = this.store.get(CollectionUtils.map((Collection)this.store.getAbbreviator().abbreviate(paths), ByteArrayUtils::intToByteArray));
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) == null) {
                result.add(new CloneChunkList());
                continue;
            }
            result.add(CloneChunkByPathIndex.decompressChunks((byte[])values.get(i), paths.get(i), null, null));
        }
        return result;
    }

    public void insertFiles(List<TokenElementInfo> elements, int chunkLength) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(CollectionUtils.mapToSet(elements, BasicTokenElementInfo::getUniformPath));
        PairList keysValues = new PairList(elements.size());
        for (TokenElementInfo element : elements) {
            List<Unit> units = FastUnifiedNormalization.getNormalizedUnits(element);
            int nonSyntheticUnits = (int)units.stream().filter(unit -> !unit.isSynthetic()).count();
            StringOffsetTransformer offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
            LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(element.getText());
            ArrayList<CloneChunk> chunks = new ArrayList();
            if (nonSyntheticUnits > 0) {
                chunks = CloneChunkByPathIndex.calculateChunks(units, chunkLength, element, offsetTransformer, rawLineOffsetConverter, nonSyntheticUnits);
            }
            keysValues.add((Object)ByteArrayUtils.intToByteArray((int)((Integer)abbreviationMap.get(element.getUniformPath()))), (Object)CloneChunkByPathIndex.compressChunks(chunks, null, true));
        }
        this.store.put(keysValues);
    }

    private static List<CloneChunk> calculateChunks(List<Unit> units, int chunkSize, TokenElementInfo elementInfo, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, int elementUnits) {
        ArrayList<CloneChunk> result = new ArrayList<CloneChunk>();
        for (int i = chunkSize - 1; i < units.size(); ++i) {
            int first = i - (chunkSize - 1);
            OptionalLong digest = CloneChunkByPathIndex.buildChunkHash(units, first, i);
            if (digest.isEmpty()) continue;
            Unit firstUnit = units.get(first);
            Unit lastUnit = units.get(first + chunkSize - 1);
            int rawStartOffset = offsetTransformer.getUnfilteredOffset(firstUnit.getFilteredStartOffset());
            int rawEndOffset = offsetTransformer.getUnfilteredOffset(lastUnit.getFilteredEndOffset()) + 1;
            int rawStartLine = rawLineOffsetConverter.getLine(rawStartOffset);
            int rawEndLine = rawLineOffsetConverter.getLine(rawEndOffset - 1) + 1;
            CloneChunk chunk = new CloneChunk(elementInfo.getUniformPath(), digest.getAsLong(), firstUnit.getIndexInElement(), rawStartLine, rawEndLine, rawStartOffset, rawEndOffset, elementUnits);
            result.add(chunk);
        }
        return result;
    }

    private static OptionalLong buildChunkHash(List<Unit> units, int first, int last) {
        try (StreamingXXHash64 hashBuilder = HASH_FACTORY.newStreamingHash64(0L);){
            for (int j = first; j <= last; ++j) {
                Unit unit = units.get(j);
                if (unit.isSynthetic()) {
                    OptionalLong optionalLong = OptionalLong.empty();
                    return optionalLong;
                }
                byte[] bytes = unit.getContent().getBytes(StandardCharsets.UTF_8);
                hashBuilder.update(bytes, 0, bytes.length);
                hashBuilder.update(UNIT_SEPARATOR, 0, UNIT_SEPARATOR.length);
            }
            OptionalLong optionalLong = OptionalLong.of(hashBuilder.getValue());
            return optionalLong;
        }
    }

    public void removePaths(List<String> paths) throws StorageException {
        this.store.remove(CollectionUtils.map((Collection)this.store.getAbbreviator().abbreviate(paths), ByteArrayUtils::intToByteArray));
    }
}

