/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CloneChunkIndexInverter
extends ChangeProcessorAnalysisStep {
    private static final int BATCH_SIZE = 500;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CloneChunkByPathIndex newByPathIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CloneChunkByPathIndex oldByPathIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CloneChunkByHashIndex byHashIndex;

    public void execute() throws StorageException {
        CloneChunkIndexInverter.invertCloneChunkIndex(this.contentDelta, this.byHashIndex, this.newByPathIndex, this.oldByPathIndex);
    }

    public static void invertCloneChunkIndex(KeyDelta contentDelta, CloneChunkByHashIndex byHashIndex, CloneChunkByPathIndex newByPathIndex, CloneChunkByPathIndex oldByPathIndex) throws StorageException {
        ArrayList allPaths = new ArrayList();
        allPaths.addAll(contentDelta.getAddedOrChangedKeysAsStrings());
        allPaths.addAll(contentDelta.getDeletedKeysAsStrings());
        for (int i = 0; i < allPaths.size(); i += 500) {
            List<String> batch = allPaths.subList(i, Math.min(i + 500, allPaths.size()));
            CloneChunkIndexInverter.processBatch(batch, byHashIndex, newByPathIndex, oldByPathIndex);
        }
    }

    private static void processBatch(List<String> paths, CloneChunkByHashIndex byHashIndex, CloneChunkByPathIndex newByPathIndex, CloneChunkByPathIndex oldByPathIndex) throws StorageException {
        List<CloneChunkList> oldChunks = oldByPathIndex.getChunksForElements(paths);
        List<CloneChunkList> newChunks = newByPathIndex.getChunksForElements(paths);
        Set<Long> changedHashes = CloneChunkIndexInverter.determineChangedHashes(oldChunks, newChunks);
        ArrayList<Long> hashList = new ArrayList<Long>(changedHashes);
        List<CloneChunkList> chunkLists = byHashIndex.getChunksForHashes(hashList);
        HashSet<String> pathSet = new HashSet<String>(paths);
        HashMap<Long, CloneChunkList> chunkListByHash = new HashMap<Long, CloneChunkList>();
        for (int i = 0; i < hashList.size(); ++i) {
            CloneChunkList cloneChunkList = chunkLists.get(i);
            chunkListByHash.put((Long)hashList.get(i), cloneChunkList);
            cloneChunkList.removeIf(chunk -> pathSet.contains(chunk.getOriginId()));
        }
        for (List list : newChunks) {
            for (CloneChunk chunk2 : list) {
                if (!changedHashes.contains(chunk2.getChunkHash())) continue;
                ((CloneChunkList)chunkListByHash.get(chunk2.getChunkHash())).add(chunk2);
            }
        }
        byHashIndex.insertChunksByHash(hashList, chunkLists);
    }

    private static Set<Long> determineChangedHashes(List<CloneChunkList> oldChunks, List<CloneChunkList> newChunks) {
        Map<Long, List<CloneChunk>> oldByHash = oldChunks.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(CloneChunk::getChunkHash));
        Map<Long, List<CloneChunk>> newByHash = newChunks.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(CloneChunk::getChunkHash));
        HashSet hashes = CollectionUtils.unionSet(oldByHash.keySet(), (Collection[])new Collection[]{newByHash.keySet()});
        hashes.removeIf(hash -> CloneChunkIndexInverter.areChunkListsEqual((List)oldByHash.get(hash), (List)newByHash.get(hash)));
        return hashes;
    }

    private static boolean areChunkListsEqual(List<CloneChunk> oldChunks, List<CloneChunk> newChunks) {
        if (oldChunks == null) {
            return newChunks == null;
        }
        if (newChunks == null) {
            return false;
        }
        if (oldChunks.size() != newChunks.size()) {
            return false;
        }
        oldChunks.sort(CloneChunk.CHUNK_COMPARATOR);
        newChunks.sort(CloneChunk.CHUNK_COMPARATOR);
        for (int i = 0; i < oldChunks.size(); ++i) {
            if (oldChunks.get(i).equals(newChunks.get(i))) continue;
            return false;
        }
        return true;
    }
}

