/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.configuration.StructuringConfiguration;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.reviews.ElementReviewChangePersister;
import com.teamscale.index.reviews.ElementReviewChangeRetriever;
import com.teamscale.index.reviews.ElementReviewStatusIndex;
import com.teamscale.index.reviews.ElementReviewUploadIndex;
import com.teamscale.index.reviews.ReviewRatingSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ReviewAnalysisConfiguration
extends AnalysisConfigurationBase {
    private static final String REVIEW_COMMENT_FINDING_NAME = "Review Comment Findings";
    public static final String REVIEW_COMMENT_FINDING_PARTITION = "code-review-findings";
    public static final String REVIEW_COMMENT_FINDING_GROUP = "Review Comment";
    public static final String CODE_REVIEW_FINDING_CATEGORY = "Code Review";
    private final CodeScopeAware<MetricDescriptor> ratingMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Review Rating", "Assessment metric for a file-based review rating.", false));
    private final CodeScopeAware<FindingDescriptor> codeReviewFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Review Comment Findings", EAnalysisTool.TEAMSCALE, EnumSet.allOf(ELanguage.class), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-code-review.md").orElseThrow()));

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.configureMetrics(proxy);
        this.configureFindings(proxy);
    }

    private void configureMetrics(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        List<CodeScopeName> metricEnabledCodeScopes = proxy.getCodeScopeNames().stream().filter(codeScope -> ((MetricDescriptor)this.ratingMetric.getValue(codeScope)).isMetricEnabled()).toList();
        if (!metricEnabledCodeScopes.isEmpty()) {
            TriggerBuilder triggerBuilder = new TriggerBuilder(ReviewRatingSynchronizer.class, ETriggerConcurrency.PARALLEL);
            triggerBuilder.setTriggerParameter("enabledCodeScopes", ITriggerParameter.of(metricEnabledCodeScopes));
            proxy.createTrigger(triggerBuilder);
            MetricSchemaProxy schema = proxy.getCodeMetricSchema();
            schema.addMetric("rating", schema.createMetricIndexSource("rating"), "Review Rating", "Review rating assessment", EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
            proxy.createProjectIndex(ElementReviewUploadIndex.class);
            proxy.createProjectIndex(CommitTreeIndex.class, "element-review-commit-tree");
            TriggerBuilder elementReviewChangeRetrieverTriggerBuilder = ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(ElementReviewChangeRetriever.class);
            proxy.createTrigger(elementReviewChangeRetrieverTriggerBuilder);
            proxy.addPostBuildCompletenessAnalysisTrigger(triggerBuilder);
            proxy.createTrigger(new TriggerBuilder(ElementReviewChangePersister.class, ETriggerConcurrency.PARALLEL));
            proxy.createProjectIndex(ElementReviewStatusIndex.class);
        }
    }

    private void configureFindings(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        List<CodeScopeName> codeScopesWithActivatedFinding = proxy.getCodeScopeNames().stream().filter(codeScope -> ((FindingDescriptor)this.codeReviewFinding.getValue(codeScope)).isActive()).toList();
        if (!codeScopesWithActivatedFinding.isEmpty()) {
            for (CodeScopeName codeScopeName : codeScopesWithActivatedFinding) {
                proxy.addFindingsSchemaEntry(CODE_REVIEW_FINDING_CATEGORY, REVIEW_COMMENT_FINDING_GROUP, (FindingDescriptor)this.codeReviewFinding.getValue(codeScopeName), codeScopeName);
            }
            proxy.addMetaIndexEntry((MetaIndex.IMetaIndexEntry)new CodeReviewEnabledMetaIndexEntry(codeScopesWithActivatedFinding));
        }
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return List.of(StructuringConfiguration.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerConfigurationItemsCodeScopeAware("Code review", null, List.of((ConfigurationItemBase)this.ratingMetric.getValue(template.getCodeScope()), (ConfigurationItemBase)this.codeReviewFinding.getValue(template.getCodeScope())));
    }

    private static boolean isCodeReviewFindingSupportEnabled(MetaIndex metaIndex, CodeScopeName codeScopeName) throws StorageException {
        CodeReviewEnabledMetaIndexEntry entry = (CodeReviewEnabledMetaIndexEntry)metaIndex.getValue(CodeReviewEnabledMetaIndexEntry.class);
        if (entry == null) {
            return false;
        }
        return entry.getCodeScopeNames().contains((Object)codeScopeName);
    }

    public static boolean isCodeReviewFindingSupportEnabled(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        Optional<CodeScopeName> codeScope = ReviewAnalysisConfiguration.getCodeScopeName(uniformPath, projectStorageSystem, historyAccessOption);
        return codeScope.isPresent() && ReviewAnalysisConfiguration.isCodeReviewFindingSupportEnabled((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null), codeScope.get());
    }

    private static Optional<CodeScopeName> getCodeScopeName(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (uniformPath.isCodeScopesPath()) {
            return uniformPath.getCodeScope();
        }
        CodeScopesMappingIndex mappingIndex = (CodeScopesMappingIndex)projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, historyAccessOption);
        return mappingIndex.getCodeScope(uniformPath);
    }

    @IndexValueClass
    private static class CodeReviewEnabledMetaIndexEntry
    implements MetaIndex.IMetaIndexEntry {
        private static final long serialVersionUID = 1L;
        private final Set<CodeScopeName> codeScopeNames;

        private CodeReviewEnabledMetaIndexEntry(Collection<CodeScopeName> codeScopeNames) {
            if (codeScopeNames.isEmpty()) {
                throw new IllegalArgumentException("codeScopeNames must not be empty");
            }
            this.codeScopeNames = new HashSet<CodeScopeName>(codeScopeNames);
        }

        public UnmodifiableSet<CodeScopeName> getCodeScopeNames() {
            return CollectionUtils.asUnmodifiable(this.codeScopeNames);
        }
    }
}

