/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import com.teamscale.index.simulink.analysis.finding.LibraryLinkCountFinding;
import com.teamscale.index.simulink.analysis.finding.LoopCountFinding;
import com.teamscale.index.simulink.analysis.finding.MatlabFunctionCountFinding;
import com.teamscale.index.simulink.analysis.finding.MaximumBlocksInSubsystemFinding;
import com.teamscale.index.simulink.analysis.finding.NestingDepthFinding;
import com.teamscale.index.simulink.analysis.finding.SFunctionCountFinding;
import com.teamscale.index.simulink.analysis.finding.StateflowChartCountFinding;
import com.teamscale.index.simulink.analysis.finding.SubsystemCountFinding;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;

public abstract class SimulinkAnalysisConfigurationBase
extends AnalysisConfigurationBase {
    protected final PairList<Class<? extends SimulinkMetricAnalysisBase>, MetricDescriptor> metricAnalyses = new PairList();
    protected final PairList<Class<? extends SimulinkFindingAnalysisBase>, FindingDescriptor> findingAnalyses = new PairList();

    public static SimulinkMetricAnalysis getMetricAnalysisAnnotation(Class<? extends SimulinkMetricAnalysisBase> metricClass) {
        SimulinkMetricAnalysis annotation = metricClass.getAnnotation(SimulinkMetricAnalysis.class);
        CCSMAssert.isNotNull((Object)annotation, (String)("Metric annotation missing for " + String.valueOf(metricClass)));
        return annotation;
    }

    public static SimulinkFindingAnalysis getFindingAnalysisAnnotation(Class<? extends SimulinkFindingAnalysisBase> findingClass) {
        SimulinkFindingAnalysis annotation = findingClass.getAnnotation(SimulinkFindingAnalysis.class);
        CCSMAssert.isNotNull((Object)annotation, (String)("Finding annotation missing for " + String.valueOf(findingClass)));
        return annotation;
    }

    protected void createMetricDescriptors(Class<? extends SimulinkMetricAnalysisBase>[] availableMetrics) {
        for (Class<? extends SimulinkMetricAnalysisBase> metricClass : availableMetrics) {
            SimulinkMetricAnalysis annotation = SimulinkAnalysisConfigurationBase.getMetricAnalysisAnnotation(metricClass);
            MetricDescriptor descriptor = new MetricDescriptor(annotation.name(), annotation.description());
            this.addMetricDescriptor(descriptor, CodeScopeAware.DEFAULT_CODE_SCOPE);
            this.metricAnalyses.add(metricClass, (Object)descriptor);
        }
    }

    protected void createFindingDescriptors(Class<? extends SimulinkFindingAnalysisBase>[] availableFindings) {
        for (Class<? extends SimulinkFindingAnalysisBase> findingClass : availableFindings) {
            SimulinkFindingAnalysis annotation = SimulinkAnalysisConfigurationBase.getFindingAnalysisAnnotation(findingClass);
            FindingDescriptor descriptor = new FindingDescriptor(annotation.name(), EAnalysisTool.TEAMSCALE, EnumSet.of(ELanguage.SIMULINK), annotation.enablement(), SimulinkAnalysisConfigurationBase.getFindingDescription(findingClass, annotation));
            this.getFindingPropertyDescriptions(findingClass).forEach((propertyName, propertyDescription) -> descriptor.setPropertyDescription(propertyName, propertyDescription));
            this.addFindingDescriptor(descriptor);
            this.findingAnalyses.add(findingClass, (Object)descriptor);
        }
    }

    protected PairList<String, String> getFindingPropertyDescriptions(Class<? extends SimulinkFindingAnalysisBase> findingClass) {
        PairList descriptions = new PairList();
        descriptions.add((Object)"Value", (Object)"The actual value of the metric.");
        return descriptions;
    }

    protected static String getFindingDescription(Class<? extends SimulinkFindingAnalysisBase> findingClass, SimulinkFindingAnalysis annotation) {
        return annotation.description();
    }

    protected void configureMetrics(ProjectCreationProxy proxy, TriggerBuilder trigger) throws ProjectConfigurationException {
        ArrayList<String> metricClasses = new ArrayList<String>();
        ArrayList<EMetricValueType> metricValueTypes = new ArrayList<EMetricValueType>();
        for (int i = 0; i < this.metricAnalyses.size(); ++i) {
            if (!((MetricDescriptor)this.metricAnalyses.getSecond(i)).isMetricEnabled()) continue;
            metricClasses.add(((Class)this.metricAnalyses.getFirst(i)).getName());
            SimulinkMetricAnalysis annotation = SimulinkAnalysisConfigurationBase.getMetricAnalysisAnnotation((Class)this.metricAnalyses.getFirst(i));
            metricValueTypes.add(annotation.valueType());
            MetricSchemaProxy metricSchema = proxy.getCodeMetricSchema();
            IMetricSource metricSource = metricSchema.createMetricIndexSource(annotation.internalName());
            metricSchema.addMetric(annotation.internalName(), metricSource, annotation.name(), annotation.description(), annotation.valueType(), annotation.aggregation(), annotation.metricProperties());
        }
        trigger.setTriggerParameter("metric.class", ITriggerParameter.of(metricClasses));
        trigger.setTriggerParameter("metric.valueType", ITriggerParameter.of(metricValueTypes));
    }

    protected void configureFindings(ProjectCreationProxy proxy, TriggerBuilder trigger, String findingIndexPartition) {
        ArrayList<String> findingClasses = new ArrayList<String>();
        for (int i = 0; i < this.findingAnalyses.size(); ++i) {
            if (!((FindingDescriptor)this.findingAnalyses.getSecond(i)).getEnablement().isEnabled()) continue;
            findingClasses.add(((Class)this.findingAnalyses.getFirst(i)).getName());
            proxy.addFindingsSchemaEntry(findingIndexPartition, ((FindingDescriptor)this.findingAnalyses.getSecond(i)).getName(), (FindingDescriptor)this.findingAnalyses.getSecond(i));
        }
        trigger.setTriggerParameter("finding.class", ITriggerParameter.of(findingClasses));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        this.addMetricsToAnalysisGroups(template);
        this.addFindingsToAnalysisGroups(template);
    }

    private void addMetricsToAnalysisGroups(ConfigurationTemplate template) {
        for (int i = 0; i < this.metricAnalyses.size(); ++i) {
            SimulinkMetricAnalysis annotation = SimulinkAnalysisConfigurationBase.getMetricAnalysisAnnotation((Class)this.metricAnalyses.getFirst(i));
            template.registerConfigurationItems(((MetricDescriptor)this.metricAnalyses.getSecond(i)).getName(), annotation.qualityIndicator(), Collections.singleton((ConfigurationItemBase)this.metricAnalyses.getSecond(i)));
        }
    }

    protected void addFindingsToAnalysisGroups(ConfigurationTemplate template) {
        for (int i = 0; i < this.findingAnalyses.size(); ++i) {
            ArrayList<Object> items = new ArrayList<Object>();
            SimulinkFindingAnalysis annotation = SimulinkAnalysisConfigurationBase.getFindingAnalysisAnnotation((Class)this.findingAnalyses.getFirst(i));
            if (this.findingAnalyses.getFirst(i) == NestingDepthFinding.class) {
                items.add(this.getOptionForField("nestingDepthThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == LibraryLinkCountFinding.class) {
                items.add(this.getOptionForField("libraryLinksThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == LoopCountFinding.class) {
                items.add(this.getOptionForField("loopThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == MatlabFunctionCountFinding.class) {
                items.add(this.getOptionForField("matlabFunctionThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == MaximumBlocksInSubsystemFinding.class) {
                items.add(this.getOptionForField("maximumBlocksInSubsystemThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == StateflowChartCountFinding.class) {
                items.add(this.getOptionForField("stateflowChartsThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == SubsystemCountFinding.class) {
                items.add(this.getOptionForField("subsystemThresholds"));
            } else if (this.findingAnalyses.getFirst(i) == SFunctionCountFinding.class) {
                items.add(this.getOptionForField("sFunctionThresholds"));
            }
            items.add((ConfigurationItemBase)this.findingAnalyses.getSecond(i));
            template.registerConfigurationItems(annotation.group(), annotation.qualityIndicator(), items);
        }
    }
}

