/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.migrations;

import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public final class V200ExternalFindingTypeIds {
    public static List<IJsonMigration> getMigrations(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ExternalFindingsGroupDescriptionIndex index = (ExternalFindingsGroupDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        List<ExternalAnalysisGroup> groups = index.getAllGroups();
        ArrayList<ExternalFindingsDescription> descriptions = new ArrayList<ExternalFindingsDescription>(index.getAllDescriptions());
        if (groups.isEmpty() || descriptions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IJsonMigration> migrations = new ArrayList<IJsonMigration>(descriptions.size());
        for (ExternalFindingsDescription description : descriptions) {
            Optional<ExternalAnalysisGroup> group = groups.stream().filter(g -> g.contains(description.getTypeId())).findFirst();
            if (group.isEmpty()) continue;
            String groupName = group.get().getGroupName();
            migrations.add(new ConfigurationOptionReplacement(description.getName(), groupName, description.getTypeId(), groupName));
        }
        return migrations;
    }
}

