/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.test.IndexValueClass;

public class JQAssistantConfiguration
extends ToolConfigurationBase {
    private static final String MAPPINGS_FILE = "jqassistant/check-mappings.tsv";
    private static final String OPTIONS_FILE = "jqassistant/check-options.tsv";
    private static final String DESCRIPTIONS_PATH = "jqassistant";
    private static final String PROJECT_FINDINGS_FILE_UNIFORM_PATH_OPTION_NAME = "jQAssistant Project Findings Files";
    @ConfigExposed(name="jQAssistant Project Findings Files", description="Comma-separated list of paths of the files in the Teamscale project to attach jQAssistant project findings to. These are jQAssistant findings that are not associated with a specific file. If multiple paths are given, the first matching file on a per-repository basis will be used.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public List<String> globalFindingsFiles = new ArrayList<String>();

    public JQAssistantConfiguration() {
        super(EAnalysisTool.JQASSISTANT, "Architecture Guidelines");
        this.declareCodeScopeAware();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware warningsEnabledForConstraints = CodeScopeAware.empty();
        CodeScopeAware warningsEnabledForConcepts = CodeScopeAware.empty();
        CodeScopeAware failuresEnabledForConstraints = CodeScopeAware.empty();
        CodeScopeAware failuresEnabledForConcepts = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : proxy.getCodeScopeNames()) {
            warningsEnabledForConstraints.setValue(codeScopeName, (Object)this.getBooleanValueOfOption("Enable warnings from constraints", codeScopeName));
            warningsEnabledForConcepts.setValue(codeScopeName, (Object)this.getBooleanValueOfOption("Enable warnings from concepts", codeScopeName));
            failuresEnabledForConstraints.setValue(codeScopeName, (Object)this.getBooleanValueOfOption("Enable failures from constraints", codeScopeName));
            failuresEnabledForConcepts.setValue(codeScopeName, (Object)this.getBooleanValueOfOption("Enable failures from concepts", codeScopeName));
        }
        proxy.addMetaIndexEntry((MetaIndex.IMetaIndexEntry)new JQAssistantOptions(this.globalFindingsFiles, (CodeScopeAware<Boolean>)warningsEnabledForConstraints, (CodeScopeAware<Boolean>)warningsEnabledForConcepts, (CodeScopeAware<Boolean>)failuresEnabledForConstraints, (CodeScopeAware<Boolean>)failuresEnabledForConcepts));
        super.configureProject(proxy);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.JQASSISTANT)) {
            return;
        }
        CodeScopeName codeScope = template.getCodeScope();
        this.createFindingTypes(codeScope);
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        this.autoExpose(CodeScopeAware.DEFAULT_CODE_SCOPE);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("globalFindingsFiles", CodeScopeAware.DEFAULT_CODE_SCOPE));
    }

    private void createFindingTypes(CodeScopeName codeScopeName) throws ProjectConfigurationException {
        Resource mappingsFile = Resource.of(JQAssistantConfiguration.class, (String)MAPPINGS_FILE);
        Map stringCheckMappingMap = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
        Multimap optionsMap = this.readOptions(OPTIONS_FILE);
        for (CheckMapping checkMapping : stringCheckMappingMap.values()) {
            String ruleId = checkMapping.checkId;
            String readableCheckName = checkMapping.getReadableCheckName();
            String description = this.getDescription(checkMapping.checkId, DESCRIPTIONS_PATH);
            String group = checkMapping.group;
            EFindingEnablement defaultEnablement = checkMapping.defaultEnablement;
            boolean autoAllowed = checkMapping.autoAllowed;
            List<ToolCheckOption> options = optionsMap.values().stream().filter(option -> option.checkId.equals(checkMapping.checkId)).toList();
            this.createFindingType(ruleId, readableCheckName, description, group, defaultEnablement, autoAllowed, options, codeScopeName);
        }
    }

    private boolean getBooleanValueOfOption(String optionName, CodeScopeName codeScopeName) {
        return (Boolean)this.getOption(optionName).retrieveValue(codeScopeName);
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return "Architecture";
    }

    @IndexValueClass
    public record JQAssistantOptions(List<String> globalFindingsFiles, CodeScopeAware<Boolean> warningsEnabledForConstraints, CodeScopeAware<Boolean> warningsEnabledForConcepts, CodeScopeAware<Boolean> failuresEnabledForConstraints, CodeScopeAware<Boolean> failuresEnabledForConcepts) implements MetaIndex.IMetaIndexEntry
    {
    }
}

