/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.CodeScopeAwareObjectBuilder;
import com.teamscale.index.dataflow.CFGConstructor;
import com.teamscale.index.dataflow.CfgConstructorResult;
import com.teamscale.index.dataflow.DataflowAnalysisRunner;
import com.teamscale.index.dataflow.DataflowConfigurationParameters;
import com.teamscale.index.dataflow.EDataflowAnalysis;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class DataFlowFindingsSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String DATA_FLOW_ANALYSIS_CONFIGURATION = "dataflow-analysis-configuration-parameters";
    public static final String ENABLE_DEAD_STORE_PARAMETER = "enable-dead-store";
    public static final String ENABLE_NULL_POINTER_PARAMETER = "enable-null-pointer";
    public static final String ENABLE_DIV_BY_ZERO_PARAMETER = "enable-division-by-zero";
    @StepParameter(value="dataflow-analysis-configuration-parameters")
    private final CodeScopeAware<DataflowConfigurationParameters> configurations = CodeScopeAware.empty();
    @StepParameter(value="enable-null-pointer")
    private CodeScopeAware<Boolean> enableNullPointerAnalysis;
    @StepParameter(value="enable-dead-store")
    private CodeScopeAware<Boolean> enableDeadStoreAnalysis;
    @StepParameter(value="enable-division-by-zero")
    private CodeScopeAware<Boolean> enableDivisionByZeroAnalysis;
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConcurrentMap<CodeScopeName, ListMap<String, IndexFinding>> findingsByCodeScope = new ConcurrentHashMap<CodeScopeName, ListMap<String, IndexFinding>>();

    public void execute() throws StorageException, ExecutionException {
        List uniformPaths = UniformPathCompatibilityUtil.convertCollection((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings());
        this.executeInParallelBatches(uniformPaths, this::runBatch);
        this.synchronizeFindingsForTokenElementIndexDelta(DataFlowFindingsSynchronizer.convertToCodeScopeAwareObject(this.findingsByCodeScope), "dataflow-findings");
    }

    private static CodeScopeAware<ListMap<String, IndexFinding>> convertToCodeScopeAwareObject(ConcurrentMap<CodeScopeName, ListMap<String, IndexFinding>> findingsByCodeScope) {
        CodeScopeAwareObjectBuilder builder = new CodeScopeAwareObjectBuilder(null);
        for (Map.Entry entry : findingsByCodeScope.entrySet()) {
            CodeScopeName codeScopeName = (CodeScopeName)entry.getKey();
            ListMap findings = (ListMap)entry.getValue();
            builder.setContents(codeScopeName, (Object)findings);
        }
        return builder.build();
    }

    private void runBatch(List<UniformPath> uniformPaths) throws StorageException {
        List<TokenElementInfo> elements = this.contentIndex.getTokenElements(UniformPathCompatibilityUtil.asUniformPathStrings(uniformPaths));
        elements.removeIf(element -> !ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage()) || !DataFlowHeuristicFactory.supportsLanguage(element.getLanguage()));
        Map<CodeScopeName, CFGConstructor> cfgConstructors = this.buildCfgConstructorsPerCodeScope(elements);
        for (TokenElementInfo element2 : elements) {
            CfgConstructorResult cfgInElement;
            DataflowConfigurationParameters configuration;
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element2);
            if (this.allAnalysesDisabled(codeScopeName) || (configuration = (DataflowConfigurationParameters)this.configurations.getValueOrNull(codeScopeName)) == null) continue;
            try {
                cfgInElement = cfgConstructors.get(codeScopeName).computeCfgForElement(element2);
            }
            catch (ConQATException e) {
                LOGGER.error(e.toString(), (Throwable)e);
                continue;
            }
            CodeScopeName codeScope = CodeScopeDetail.getCodeScopeNameFromTokenElement(element2);
            if (((Boolean)this.enableDeadStoreAnalysis.getValue(codeScope)).booleanValue()) {
                this.addFindings(codeScope, DataFlowFindingsSynchronizer.runDataflowAnalysis(element2, cfgInElement, EDataflowAnalysis.DEAD_STORE, configuration));
            }
            if (((Boolean)this.enableNullPointerAnalysis.getValue(codeScope)).booleanValue()) {
                this.addFindings(codeScope, DataFlowFindingsSynchronizer.runDataflowAnalysis(element2, cfgInElement, EDataflowAnalysis.NULL_POINTER, configuration));
            }
            if (!((Boolean)this.enableDivisionByZeroAnalysis.getValue(codeScope)).booleanValue()) continue;
            this.addFindings(codeScope, DataFlowFindingsSynchronizer.runDataflowAnalysis(element2, cfgInElement, EDataflowAnalysis.DIVISION_BY_ZERO, configuration));
        }
    }

    private Map<CodeScopeName, CFGConstructor> buildCfgConstructorsPerCodeScope(List<TokenElementInfo> elements) {
        DataFlowFindingsSynchronizer.logErrorsForCodeScopesWithoutConfiguration(elements, this.configurations);
        HashMap<CodeScopeName, CFGConstructor> cfgConstructors = new HashMap<CodeScopeName, CFGConstructor>();
        for (CodeScopeName codeScopeName : this.configurations.getCodeScopeNames()) {
            DataflowConfigurationParameters configuration = (DataflowConfigurationParameters)this.configurations.getValue(codeScopeName);
            try {
                cfgConstructors.put(codeScopeName, new CFGConstructor(configuration.buildTokenTransformations()));
            }
            catch (ConQATException e) {
                LOGGER.error("Could not generate token transformations for code scope {}. Skipping files. Error: {}", (Object)codeScopeName, (Object)e.getMessage(), (Object)e);
            }
        }
        return cfgConstructors;
    }

    private boolean allAnalysesDisabled(CodeScopeName codeScopeName) {
        return (Boolean)this.enableDeadStoreAnalysis.getValue(codeScopeName) == false && (Boolean)this.enableNullPointerAnalysis.getValue(codeScopeName) == false && (Boolean)this.enableDivisionByZeroAnalysis.getValue(codeScopeName) == false;
    }

    private static void logErrorsForCodeScopesWithoutConfiguration(List<TokenElementInfo> elements, CodeScopeAware<DataflowConfigurationParameters> configurations) {
        HashSet<CodeScopeName> codeScopesWithoutConfiguration = new HashSet<CodeScopeName>();
        for (TokenElementInfo element : elements) {
            DataflowConfigurationParameters configuration;
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            if (codeScopesWithoutConfiguration.contains(codeScopeName) || (configuration = (DataflowConfigurationParameters)configurations.getValueOrNull(codeScopeName)) != null) continue;
            codeScopesWithoutConfiguration.add(codeScopeName);
            LOGGER.error("Could not find data-flow analysis configuration for code scope {} when analyzing file {} of language {}. Skipping all files in this code scope.", (Object)codeScopeName, (Object)element.getUniformPath(), (Object)element.getLanguage());
        }
    }

    private void addFindings(CodeScopeName codeScope, ListMap<String, IndexFinding> entries) {
        ((List)entries.getValues()).forEach(value -> value.setCodeScopeName(codeScope));
        this.findingsByCodeScope.computeIfAbsent(codeScope, codeScopeName -> new ListMap()).addAll(entries);
    }

    private static ListMap<String, IndexFinding> runDataflowAnalysis(TokenElementInfo elementInfo, CfgConstructorResult cfg, EDataflowAnalysis analysisType, DataflowConfigurationParameters configuration) {
        DataflowAnalysisRunner runner = new DataflowAnalysisRunner(configuration, analysisType);
        return runner.process(elementInfo, cfg);
    }
}

