/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeDataFlowHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.rules.CPPMethodRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.rules.GotoRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CaseLabelRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ForRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IgnoreRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ReturnRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.SimpleStatementRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTokenPatternMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTypeMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SimpleStatementMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SubTypeMatcher;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class CppDataFlowHeuristic
extends CLikeDataFlowHeuristicBase {
    private static final PairList<IShallowEntityMatcher, IControlFlowRule> RULES = new PairList();
    private static final IShallowEntityMatcher ASSEMBLER_CODE_MATCHER = entity -> CollectionUtils.asHashSet((Object[])new String[]{"inline assembler call", "inline assembler block", "inline assembler function"}).contains(entity.getSubtype()) || !entity.ownStartTokens().isEmpty() && ((IToken)entity.ownStartTokens().getFirst()).getText().startsWith("__ASM");
    private static final IShallowEntityMatcher EXPANDED_MACRO_MATCHER = new SubTypeMatcher("expanded macro");
    private static final IShallowEntityMatcher TERMINATE_OR_ABORT_STATEMENTS = new ShallowEntityOrMatcher(new ShallowEntityTokenPatternMatcher(new TokenPattern().alternative(new Object[]{new TokenPattern().optional(new Object[]{TokenPattern.text((String)"std"), ETokenType.SCOPE}).alternative(new Object[]{TokenPattern.text((String)"exit"), TokenPattern.text((String)"abort"), TokenPattern.text((String)"terminate"), TokenPattern.text((String)"quick_exit"), TokenPattern.text((String)"_Exit"), TokenPattern.text((String)"__builtin_trap")}).sequence(new Object[]{ETokenType.LPAREN})})));
    private static final IShallowEntityMatcher SINGLE_IDENTIFIER_STATEMENTS = new ShallowEntityTokenPatternMatcher(new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.SEMICOLON}));

    @Override
    public PairList<String, List<ShallowEntity>> extractExecutables(String uniformPath, List<ShallowEntity> entities) {
        PairList executableMethods = new PairList();
        Predicate<ShallowEntity> isUnionShallowEntity = parentEntity -> TokenStreamUtils.contains((List)parentEntity.ownStartTokens(), (ETokenType)ETokenType.UNION);
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)methodEntity, isUnionShallowEntity).isPresent() || methodEntity.getChildren().isEmpty() && !"constructor".equals(methodEntity.getSubtype()) || CppDataFlowHeuristic.isLambda(methodEntity) || "preprocessor code".equals(methodEntity.getSubtype())) continue;
            CCSMAssert.isNotNull((Object)methodEntity.getName());
            executableMethods.add((Object)methodEntity.getName(), Collections.singletonList(methodEntity));
        }
        return executableMethods;
    }

    private static boolean isLambda(ShallowEntity methodEntity) {
        return "lambda expression".equals(methodEntity.getSubtype()) || "block expression".equals(methodEntity.getSubtype());
    }

    @Override
    protected PairList<IShallowEntityMatcher, IControlFlowRule> getRules() {
        PairList rules = new PairList(RULES);
        CppDataFlowHeuristic.addDefaultRules((PairList<IShallowEntityMatcher, IControlFlowRule>)rules);
        return rules;
    }

    public static PairList<String, List<ShallowEntity>> extractLambdasNotNestedInMethods(List<ShallowEntity> entities) {
        PairList executableMethods = new PairList();
        Predicate<ShallowEntity> isClassOrMethodEntity = parentEntity -> parentEntity.getType() == EShallowEntityType.METHOD || parentEntity.getType() == EShallowEntityType.TYPE;
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            boolean scopeParentIsMethod;
            Optional scopeParent = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)methodEntity, isClassOrMethodEntity);
            boolean bl = scopeParentIsMethod = scopeParent.isPresent() && ((ShallowEntity)scopeParent.get()).getType() == EShallowEntityType.METHOD;
            if (!CppDataFlowHeuristic.isLambda(methodEntity) || scopeParentIsMethod || "preprocessor code".equals(methodEntity.getSubtype())) continue;
            String name = Optional.ofNullable(methodEntity.getName()).orElseGet(() -> "anonymous" + methodEntity.getStartOffset());
            executableMethods.add((Object)name, Collections.singletonList(methodEntity));
        }
        return executableMethods;
    }

    static {
        RULES.add((Object)FOR_SUBTYPE, (Object)new ForRule(ETokenType.COLON));
        RULES.add((Object)new SubTypeMatcher("foreach"), (Object)new ForRule(ETokenType.COMMA.or(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"in"})})));
        RULES.add((Object)new SubTypeMatcher("for each"), (Object)new ForRule(ITokenMatcher.hasText((String[])new String[]{"in"})));
        RULES.add((Object)new SimpleStatementMatcher("goto"), (Object)new GotoRule());
        RULES.add((Object)ShallowEntityTypeMatcher.METHOD_MATCHER, (Object)new CPPMethodRule());
        RULES.add((Object)ASSEMBLER_CODE_MATCHER, (Object)new SimpleStatementRule(false));
        RULES.add((Object)EXPANDED_MACRO_MATCHER, (Object)new SimpleStatementRule(false));
        RULES.add((Object)TERMINATE_OR_ABORT_STATEMENTS, (Object)new ReturnRule());
        RULES.add((Object)SINGLE_IDENTIFIER_STATEMENTS, (Object)new IgnoreRule());
        RULES.add((Object)ALL_CASE_LABELS, (Object)new CaseLabelRule(true, CASE_SUBTYPE_BELOW_SWITCH, DEFAULT_SUBTYPE_BELOW_SWITCH, BREAK_SUBTYPE, RETURN_OR_THROW_STATEMENTS, "case", ":"));
    }
}

