/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation;

import com.esotericsoftware.kryo.KryoException;
import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.CFGConstructor;
import com.teamscale.index.dataflow.CfgConstructorResult;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.dataflow.taintpropagation.CfgComplexityFilter;
import com.teamscale.index.dataflow.taintpropagation.MethodTaintGraphBarrierIndex;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysis;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class MethodTaintGraphGenerationAnalysisRunner
extends ChangeProcessorAnalysisStep {
    public static final String TAINT_ANALYSIS_OPTIONS_PARAMETER = "taint-analysis-options";
    public static final String FINDINGS_PARTITION = "FailedMethodTaintGraphGenerationFindings";
    private static final String ENABLE_DETAILED_DEBUG_LOGS_FOR_KRYO_JVM_FLAG = "com.teamscale.debug.taint-analysis.detailed-logs-kryo";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP);
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @IndexAccess(indexName="findings-schema", value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(indexName="content", value=EIndexAccessMode.READ_ONLY)
    private TokenElementIndex contentIndex;
    @IndexAccess(indexName="_meta", value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementMetadataIndex tokenElementMetadataIndex;
    @IndexAccess(indexName="method-taint-graph-barrier", value=EIndexAccessMode.READ_WRITE)
    private MethodTaintGraphBarrierIndex barrierIndex;
    @IndexAccess(indexName="method-taint-graphs", value=EIndexAccessMode.READ_WRITE)
    private MethodTaintGraphIndex methodTaintGraphIndex;
    @IndexAccess(indexName="findings", value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @StepParameter(value="taint-analysis-options", optional=true)
    private final EnumSet<ETaintAnalysisOptions> options = EnumSet.noneOf(ETaintAnalysisOptions.class);
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    private Set<String> sapSystemIds = new HashSet<String>();
    private final Map<String, ArrayList<IndexFinding>> findings = new HashMap<String, ArrayList<IndexFinding>>();

    public void execute() throws StorageException {
        this.sapSystemIds = AbapProjectUtils.resolveSapConfigurationIdsForProject(this.externalCredentialsIndex, this.metaIndex);
        try {
            this.methodTaintGraphIndex.removeForUniformPaths(this.contentDelta.getDeletedKeysAsStrings());
            this.findingsIndex.removeFindingsForPartitionsAndPaths(FINDINGS_PARTITION, this.contentDelta.getDeletedKeysAsStrings());
            List<TokenElementInfo> supportedAddedOrChangedElements = this.contentIndex.getTokenElements(this.contentDelta.getAddedOrChangedKeysAsStrings()).stream().filter(info -> SUPPORTED_LANGUAGES.contains(info.getLanguage()) && DataFlowHeuristicFactory.supportsLanguage(info.getLanguage())).toList();
            this.createMethodTaintGraphsAndWriteToIndex(supportedAddedOrChangedElements);
            this.barrierIndex.modifyIndex(this.getSchedulingCommit());
            this.findingsIndex.setFindings(FINDINGS_PARTITION, new PairList(this.findings), this.findingsSchemaIndex.getFindingsSchema());
        }
        catch (StorageException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private void createMethodTaintGraphsAndWriteToIndex(List<TokenElementInfo> elements) throws StorageException {
        CFGConstructor cfgConstructor;
        try {
            cfgConstructor = new CFGConstructor(Collections.emptyList());
        }
        catch (ConQATException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return;
        }
        Set<String> pathsOfRfcEnabledFiles = this.getUniformPathsOfRfcEnabledFiles(elements);
        for (TokenElementInfo element : elements) {
            CfgConstructorResult cfgsInElement;
            try {
                cfgsInElement = cfgConstructor.computeCfgForElement(element);
            }
            catch (ConQATException e) {
                LOGGER.error(e.toString(), (Throwable)e);
                continue;
            }
            if (cfgsInElement == null || cfgsInElement.getGraphs() == null) {
                LOGGER.warn("Did not find any control flow graphs on element {}. Ignoring this element completely.", (Object)element.getUniformPath());
                continue;
            }
            boolean isRfcEnabled = pathsOfRfcEnabledFiles.contains(element.getUniformPath());
            List<MethodTaintGraph> taintGraphs = this.analyzeControlFlowGraphs(element, cfgsInElement, isRfcEnabled);
            this.writeMethodTaintGraphsToIndex(element, taintGraphs);
        }
    }

    private Set<String> getUniformPathsOfRfcEnabledFiles(List<TokenElementInfo> files) {
        List<List<IFileMetadata>> metadataForFiles;
        if (this.sapSystemIds.isEmpty()) {
            return Collections.emptySet();
        }
        List<String> uniformPathsToLookupInIndex = files.stream().map(BasicTokenElementInfo::getUniformPath).toList();
        try {
            metadataForFiles = this.tokenElementMetadataIndex.getMetadataForFiles(uniformPathsToLookupInIndex);
        }
        catch (StorageException e) {
            LOGGER.warn("Could not determine if ABAP files are RFC-enabled. Assuming false. {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < metadataForFiles.size(); ++i) {
            List<IFileMetadata> metadataForFile = metadataForFiles.get(i);
            if (!metadataForFile.stream().anyMatch(metaData -> {
                AbapFileMetadata abapMetaData;
                return metaData instanceof AbapFileMetadata && (abapMetaData = (AbapFileMetadata)metaData).isRfcEnabled();
            })) continue;
            result.add(uniformPathsToLookupInIndex.get(i));
        }
        return result;
    }

    private List<MethodTaintGraph> analyzeControlFlowGraphs(TokenElementInfo element, CfgConstructorResult cfgConstructorResult, boolean isRFCEnabledFile) {
        MethodTaintGraphGenerationAnalysis.debugAnalysisIterationPerMethod.clear();
        List<ControlFlowGraph> cfgs = cfgConstructorResult.getGraphs();
        LOGGER.debug("Got {} CFGs for element {}", (Object)cfgs.size(), (Object)element.getUniformPath());
        StringOffsetTransformer offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(element.getText());
        HashMap<ControlFlowGraph, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> cfgResultCache = new HashMap<ControlFlowGraph, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>>();
        ArrayList<MethodTaintGraph> createdGraphs = new ArrayList<MethodTaintGraph>();
        for (ControlFlowGraph cfg : cfgs) {
            this.analyzeControlFlowGraph(element, cfg, cfgConstructorResult, offsetTransformer, rawLineOffsetConverter, cfgResultCache, isRFCEnabledFile).ifPresent(createdGraphs::add);
        }
        return createdGraphs;
    }

    private Optional<MethodTaintGraph> analyzeControlFlowGraph(TokenElementInfo element, ControlFlowGraph cfg, CfgConstructorResult cfgConstructorResult, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, Map<ControlFlowGraph, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> cfgResultCache, boolean isRFCEnabledFile) {
        String memoryErrorMessage = "Taint propagation analysis failed badly in element " + element.getUniformPath() + ", method " + cfg.getMethodName();
        try {
            Optional<String> message = CfgComplexityFilter.getMessageIfTooComplex(cfg);
            if (message.isPresent()) {
                LOGGER.warn("ignoring CFG for {} since it is too complex. {}", (Object)cfg.getMethodName(), (Object)message.get());
                this.createFinding(element, cfg, message.get(), offsetTransformer, rawLineOffsetConverter);
                return Optional.empty();
            }
            LOGGER.debug("Creating MethodTaintGraph for method {}", (Object)cfg.getMethodName());
            MethodTaintGraphGenerationAnalysis analysis = new MethodTaintGraphGenerationAnalysis(this.getSchedulingCommit().getTimestamp(), this.options, cfgConstructorResult.getGraphs(), cfgResultCache, isRFCEnabledFile);
            analysis.analyze(element, cfg, null, cfgConstructorResult.getEntities(), rawLineOffsetConverter);
            analysis.analysisAbortMessage.ifPresent(abortMessage -> this.createFinding(element, cfg, (String)abortMessage, offsetTransformer, rawLineOffsetConverter));
            return analysis.getResultingTaintGraph();
        }
        catch (Exception e) {
            LOGGER.error("Taint propagation analysis failed badly in element {}, method {}", (Object)element.getUniformPath(), (Object)cfg.getMethodName(), (Object)e);
            return Optional.empty();
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            LOGGER.error(memoryErrorMessage, (Throwable)e);
            throw e;
        }
    }

    private void createFinding(TokenElementInfo element, ControlFlowGraph cfg, String message, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        Object location = cfg.getRoot().isSynthetic() || cfg.getRoot().getTokens().isEmpty() ? new ElementLocation(element.getUniformPath()) : TaintAnalysisUtils.createLocationForTokens(cfg.getRoot().getTokens(), element, offsetTransformer, rawLineOffsetConverter);
        IndexFinding finding = new IndexFinding("Taint Graph Generation", "Dataflow", message, location);
        this.findings.putIfAbsent(element.getUniformPath(), new ArrayList());
        this.findings.get(element.getUniformPath()).add(finding);
    }

    private void writeMethodTaintGraphsToIndex(TokenElementInfo element, List<MethodTaintGraph> newTaintGraphs) throws StorageException {
        if (this.doGraphsStoredInIndexHaveSameDataflow(element, newTaintGraphs)) {
            LOGGER.debug("Skipping update of method taint graphs for element {} at {} as they have the same dataflow.", (Object)element.getUniformPath(), (Object)this.getSchedulingCommit());
            return;
        }
        LOGGER.debug("Storing method taint graphs in index for {} at {}.", (Object)element.getUniformPath(), (Object)this.getSchedulingCommit());
        this.methodTaintGraphIndex.setMethodTaintGraphs(element.getUniformPath(), newTaintGraphs);
        try {
            this.methodTaintGraphIndex.getMethodTaintGraphs(element.getUniformPath());
        }
        catch (KryoException e) {
            String errorDetailsHint = this.logDeserializationErrorDetailsInFile(element, e, newTaintGraphs);
            LOGGER.error("Could not deserialize new taint graphs for path " + element.getUniformPath() + " at " + String.valueOf(this.getSchedulingCommit()) + ". This will likely lead to consecutive errors in the taint analysis. " + errorDetailsHint, (Throwable)e);
        }
    }

    private boolean doGraphsStoredInIndexHaveSameDataflow(TokenElementInfo element, List<MethodTaintGraph> newTaintGraphs) throws StorageException {
        try {
            Map<String, MethodTaintGraph> oldTaintGraphs = this.methodTaintGraphIndex.getMethodTaintGraphs(element.getUniformPath());
            return MethodTaintGraphGenerationAnalysisRunner.allSameDataflow(oldTaintGraphs, newTaintGraphs);
        }
        catch (KryoException e) {
            String errorDetailsHint = this.logDeserializationErrorDetailsInFile(element, e, newTaintGraphs);
            LOGGER.warn("Could not deserialize old method taint graphs for element " + element.getUniformPath() + "at " + String.valueOf(this.getSchedulingCommit()) + ". This does only affect the performance of this runner but not the results it produces. " + errorDetailsHint, (Throwable)e);
            return false;
        }
    }

    private static boolean allSameDataflow(Map<String, MethodTaintGraph> graphs1, List<MethodTaintGraph> graphs2) {
        if (graphs2.size() != graphs1.size()) {
            return false;
        }
        for (MethodTaintGraph graph : graphs2) {
            MethodTaintGraph otherGraph = graphs1.get(graph.getMethodIdentifier());
            if (otherGraph != null && otherGraph.containsSameDataflowAs(graph)) continue;
            return false;
        }
        return true;
    }

    private String logDeserializationErrorDetailsInFile(TokenElementInfo element, KryoException deserializationException, List<MethodTaintGraph> createdGraphs) throws StorageException {
        boolean detailedDebugLogsEnabled = Boolean.parseBoolean(System.getProperty(ENABLE_DETAILED_DEBUG_LOGS_FOR_KRYO_JVM_FLAG));
        if (!detailedDebugLogsEnabled) {
            return "";
        }
        String logFileContent = this.createDeserializationErrorDetails(element, deserializationException, createdGraphs);
        Path logsDir = TeamscaleInstallationUtils.getRootPath((String)"logs");
        String logFileName = "TaintGraphDeserialization_" + System.currentTimeMillis() + ".log";
        Path logFile = logsDir.resolve(logFileName);
        try {
            FileSystemUtils.writeFileUTF8((Path)logFile, (String)logFileContent);
            return "Additional information stored in " + logFileName + ".";
        }
        catch (IOException ex) {
            LOGGER.error("Could not deserialize taint graph for path {}. Could not store additional information in log file", (Object)element.getUniformPath(), (Object)ex);
            return "";
        }
    }

    private String createDeserializationErrorDetails(TokenElementInfo element, KryoException deserializationException, List<MethodTaintGraph> createdGraphs) throws StorageException {
        StringWriter stackTrace = new StringWriter();
        deserializationException.printStackTrace(new PrintWriter(stackTrace));
        StringBuffer jsonSerializedGraphs = new StringBuffer();
        for (MethodTaintGraph graph : createdGraphs) {
            jsonSerializedGraphs.append(graph).append("\n\n");
        }
        return MessageFormat.format("Exception when deserializing Taint graphs\nfor file {0}\nat commit {1}\nCurrent time {2}\nException: {3}\n{4}\n\nGraphs for file:\n{5}\n\nSerialized Data:\n{6}\n", element.getUniformPath(), this.getSchedulingCommit(), Instant.now(), deserializationException.getMessage(), stackTrace, jsonSerializedGraphs, Base64.getEncoder().encodeToString(this.methodTaintGraphIndex.getRawSerializedDataForUniformPath(element.getUniformPath())));
    }
}

