/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.configuration.TaintAnalysisConfiguration;
import com.teamscale.index.dataflow.taintpropagation.MethodTaintGraphBarrierIndex;
import com.teamscale.index.dataflow.taintpropagation.analysisglobal.MethodTaintGraphAnalyzer;
import com.teamscale.index.dataflow.taintpropagation.methodindex.EnrichedMethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodCallIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.ETaintSinkType;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraphWithPaths;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSourceBase;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.PerformanceMonitor;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TaintAnalysisRunner
extends FindingsSynchronizingAnalyzingStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TAINT_ANALYSIS_OPTIONS_PARAMETER = "taint-analysis-options";
    public static final String SANITIZER_PATTERNS_PARAMETER = "sanitizer-patterns";
    public static final String FINDING_PARTITION = "datataint-findings";
    private static final String REMAINING_QUEUE_SIZE_LOG_CONFIG_OPTION = "com.teamscale.taint-analysis.remainingQueueSizeLog";
    public static boolean storeDebugInfo = false;
    @VisibleForTesting
    public static Collection<String> recomputedMethodIdentifiersInLastIteration = Collections.emptyList();
    @DeltaSource(value=MethodTaintGraphBarrierIndex.class)
    private KeyDelta taintGraphBarrierIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodTaintGraphIndex taintGraphIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private EnrichedMethodTaintGraphIndex enrichedTaintGraphIndex;
    @IndexAccess(indexName="method-calls", value=EIndexAccessMode.READ_ONLY)
    private MethodCallIndex methodCallIndex;
    @StepParameter(value="taint-analysis-options", optional=true)
    private final Set<String> options = new HashSet<String>();
    @StepParameter(value="path-limit")
    private int maxPathsBetweenStatements = 100;
    @StepParameter(value="sanitizer-patterns", optional=true)
    private final List<String> sanitizerPatterns = new ArrayList<String>();
    private Map<String, Set<String>> calledMethodsMap;
    private final Map<String, PerformanceMonitor> performanceMonitors = new HashMap<String, PerformanceMonitor>();
    private final Set<String> identifiersOfAffectedMethods = new HashSet<String>();
    private final Map<String, MethodTaintGraphWithPaths> taintGraphsToUpdate = new HashMap<String, MethodTaintGraphWithPaths>();

    private void startMonitor(String name) {
        CCSMAssert.isFalse((boolean)this.performanceMonitors.containsKey(name), (String)"Trying to start an existing performance monitor");
        this.performanceMonitors.put(name, PerformanceMonitor.create());
    }

    private void stopMonitor(String name) {
        CCSMAssert.isTrue((boolean)this.performanceMonitors.containsKey(name), (String)"Trying to stop an unknown performance monitor");
        this.performanceMonitors.get(name).stop();
    }

    private void logPerformance() {
        StringBuilder sb = new StringBuilder("Performance statistics (discarding entries with 0 seconds):\n");
        for (Map.Entry<String, PerformanceMonitor> entry : this.performanceMonitors.entrySet()) {
            if (!entry.getValue().isStopped()) {
                entry.getValue().stop();
            }
            if (entry.getValue().getSeconds() == 0L) continue;
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getSeconds());
            sb.append(" seconds\n");
        }
        LOGGER.debug(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws StorageException {
        try {
            this.findingsIndex.removeFindingsForPartitionsAndPaths(FINDING_PARTITION, this.contentDelta.getDeletedKeysAsStrings());
            if (this.taintGraphBarrierIndexDelta.isEmpty()) {
                return;
            }
            Map<String, MethodTaintGraph> taintGraphbyMethodId = this.taintGraphIndex.getAllMethodTaintGraphs();
            Map<String, MethodTaintGraphWithPaths> enrichedTaintGraphByMethodId = this.enrichedTaintGraphIndex.getAllMethodTaintGraphs();
            List<String> workList = this.generateWorkList(taintGraphbyMethodId, enrichedTaintGraphByMethodId);
            Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs = TaintAnalysisRunner.getOldGraphsForUnchangedGraphIds(new HashSet<String>(workList), enrichedTaintGraphByMethodId);
            this.performTaintAnalysis(workList, enrichedMethodTaintGraphs, taintGraphbyMethodId);
            if (storeDebugInfo) {
                recomputedMethodIdentifiersInLastIteration = workList;
            }
            this.enrichedTaintGraphIndex.updateMethodTaintGraphs(this.taintGraphsToUpdate, this.identifiersOfAffectedMethods);
            ListMap<String, IndexFinding> findings = this.createFindings(workList);
            PairList values = PairList.fromListMap(findings);
            this.findingsIndex.setFindings(FINDING_PARTITION, values, this.findingsSchemaIndex.getFindingsSchema());
        }
        finally {
            this.logPerformance();
        }
    }

    private List<String> generateWorkList(Map<String, MethodTaintGraph> methodTaintGraphEntries, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphEntries) throws StorageException {
        UnmodifiableSet allTaintGraphIds = CollectionUtils.asUnmodifiable(methodTaintGraphEntries.keySet());
        UnmodifiableSet allEnrichedTaintGraphIds = CollectionUtils.asUnmodifiable(enrichedMethodTaintGraphEntries.keySet());
        UnmodifiableSet newTaintGraphIds = CollectionUtils.asUnmodifiable(TaintAnalysisRunner.getGraphsIdsFromCommit(methodTaintGraphEntries, this.getSchedulingCommit()));
        HashSet deletedGraphIds = CollectionUtils.differenceSet((Collection)allEnrichedTaintGraphIds, (Collection[])new Collection[]{allTaintGraphIds});
        deletedGraphIds.forEach(enrichedMethodTaintGraphEntries::remove);
        this.calledMethodsMap = TaintAnalysisRunner.loadCalledMethodsMap(this.methodCallIndex);
        Map<String, Set<String>> callingMethodsMap = TaintAnalysisRunner.invertMethodCallMap(this.calledMethodsMap);
        ArrayList changedMethods = CollectionUtils.sort(TaintAnalysisRunner.buildCallingGraphIdentifierClosure(enrichedMethodTaintGraphEntries, CollectionUtils.unionSet((Collection)deletedGraphIds, (Collection[])new Collection[]{newTaintGraphIds}), x -> true, callingMethodsMap));
        changedMethods.removeAll(deletedGraphIds);
        Pair topSorted = CollectionUtils.topSortRemoveCycles((Collection)changedMethods, callingMethodsMap::get, this.calledMethodsMap::get);
        Set cycleBreakingMethods = (Set)topSorted.getSecond();
        Set<String> changedMethodsWithoutCycleInfluences = TaintAnalysisRunner.buildCallingGraphIdentifierClosure(enrichedMethodTaintGraphEntries, CollectionUtils.unionSet((Collection)deletedGraphIds, (Collection[])new Collection[]{newTaintGraphIds}), ((Predicate<String>)cycleBreakingMethods::contains).negate(), callingMethodsMap);
        changedMethodsWithoutCycleInfluences.retainAll((Collection<?>)allTaintGraphIds);
        List workList = CollectionUtils.filter((Collection)((Collection)topSorted.getFirst()), changedMethodsWithoutCycleInfluences::contains);
        this.identifiersOfAffectedMethods.addAll(workList);
        this.identifiersOfAffectedMethods.addAll(deletedGraphIds);
        TaintAnalysisRunner.logWorklistSummary(allTaintGraphIds.size(), newTaintGraphIds.size(), deletedGraphIds.size(), cycleBreakingMethods, workList.size());
        return workList;
    }

    private static void logWorklistSummary(int totalKnownTaintGraphs, int newTaintGraphs, int deletedGraphs, Set<String> cycleBreakingMethods, int workListSize) {
        LOGGER.info("TaintGraphIndex Summary:\n" + totalKnownTaintGraphs + " taint graphs in total\n" + deletedGraphs + " deleted graphs\n" + newTaintGraphs + " new graphs\n" + workListSize + " graphs must be recomputed for commit");
        if (!cycleBreakingMethods.isEmpty()) {
            LOGGER.warn("Found recursive cycles. Ignoring " + cycleBreakingMethods.size() + " methods to break the cycle.");
            String methodNames = StringUtils.concat(cycleBreakingMethods, (String)"\n");
            LOGGER.info("Ignored methods in cycles:\n" + methodNames + "\n");
        }
    }

    private static Map<String, Set<String>> loadCalledMethodsMap(MethodCallIndex callIndex) throws StorageException {
        HashMap<String, Set<String>> methodsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, ArrayList<String>> entry : callIndex.getAllMethodCallReferences().entrySet()) {
            methodsMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return methodsMap;
    }

    private static Map<String, Set<String>> invertMethodCallMap(Map<String, Set<String>> calledMethodsMap) {
        HashMap<String, Set<String>> callingMethodsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : calledMethodsMap.entrySet()) {
            String callingMethod = entry.getKey();
            for (String calledMethod : entry.getValue()) {
                callingMethodsMap.computeIfAbsent(calledMethod, k -> new HashSet()).add(callingMethod);
            }
        }
        return callingMethodsMap;
    }

    private void performTaintAnalysis(List<String> workList, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, Map<String, MethodTaintGraph> methodTaintGraphEntries) {
        int workListSize = workList.size();
        this.startMonitor("taintAnalysisLoop");
        MethodTaintGraphAnalyzer graphAnalyzer = new MethodTaintGraphAnalyzer(this.calledMethodsMap, this.getSchedulingCommit(), EnumUtils.valuesOf(ETaintAnalysisOptions.class, this.options), this.maxPathsBetweenStatements);
        ArrayList<String> uniformPathsForSinkLocations = new ArrayList<String>();
        for (int i = 0; i < workListSize; ++i) {
            String currentMethodId = workList.get(i);
            if (Boolean.getBoolean(REMAINING_QUEUE_SIZE_LOG_CONFIG_OPTION)) {
                LOGGER.info("TaintAnalysis WorkQueue remaining: " + (workListSize - i) + " of " + workListSize + " Current: " + currentMethodId);
            }
            MethodTaintGraph currentEntry = methodTaintGraphEntries.get(currentMethodId);
            try {
                this.analyzeMethodTaintGraph(currentEntry, enrichedMethodTaintGraphs, graphAnalyzer);
                this.updateEnrichedTaintGraphIndex(enrichedMethodTaintGraphs, uniformPathsForSinkLocations, currentEntry);
                continue;
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Memory error while processing graph " + currentEntry.getMethodIdentifier(), (Throwable)e);
                throw e;
            }
            catch (StackOverflowError e) {
                LOGGER.error("StackOverflowError while processing graph " + currentEntry.getMethodIdentifier(), (Throwable)e);
                throw e;
            }
        }
        this.stopMonitor("taintAnalysisLoop");
    }

    private void analyzeMethodTaintGraph(MethodTaintGraph methodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, MethodTaintGraphAnalyzer graphAnalyzer) {
        String methodId = methodTaintGraph.getMethodIdentifier();
        if (TaintAnalysisUtils.detailedTaintAnalysisLoggingEnabled()) {
            LOGGER.debug("TaintAnalysis: processing " + methodId);
        }
        graphAnalyzer.processMethodTaintGraph(methodTaintGraph, enrichedMethodTaintGraphs);
        if (enrichedMethodTaintGraphs.containsKey(methodId)) {
            enrichedMethodTaintGraphs.get(methodId).addInfluencingMethodIdentifiers((Collection<String>)this.calledMethodsMap.getOrDefault(methodId, (Set<String>)CollectionUtils.emptySet()));
        }
    }

    private void updateEnrichedTaintGraphIndex(Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, List<String> uniformPathsForSinkLocations, MethodTaintGraph currentEntry) {
        if (enrichedMethodTaintGraphs.containsKey(currentEntry.getMethodIdentifier())) {
            MethodTaintGraphWithPaths enrichedMethodTaintGraph = enrichedMethodTaintGraphs.get(currentEntry.getMethodIdentifier());
            this.taintGraphsToUpdate.put(currentEntry.getMethodIdentifier(), enrichedMethodTaintGraph);
            uniformPathsForSinkLocations.addAll(enrichedMethodTaintGraph.getUniformPathsOfSinks());
        } else {
            this.identifiersOfAffectedMethods.add(currentEntry.getMethodIdentifier());
        }
    }

    private static Map<String, MethodTaintGraphWithPaths> getOldGraphsForUnchangedGraphIds(Set<String> potentiallyChangedGraphIds, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphEntries) {
        return enrichedMethodTaintGraphEntries.entrySet().stream().filter(entry -> !potentiallyChangedGraphIds.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ListMap<String, IndexFinding> createFindings(List<String> potentiallyChangedGraphIds) throws StorageException, AssertionError {
        Map<ETaintSinkType, Set<String>> sanitizersBySinkType = TaintAnalysisRunner.readSanitizerPatterns(this.sanitizerPatterns);
        List<String> uniformPathsOfPotentiallyChangedGraphs = potentiallyChangedGraphIds.stream().map(TaintAnalysisUtils::getUniformPathFromMethodIdentifier).distinct().collect(Collectors.toList());
        ListMap findings = new ListMap();
        this.identifiersOfAffectedMethods.stream().map(TaintAnalysisUtils::getUniformPathFromMethodIdentifier).distinct().forEach(path -> findings.addAll(path, new ArrayList()));
        HashMap<String, TokenElementInfo> scope = new HashMap<String, TokenElementInfo>();
        PairList uniformPathsAndTokenElements = PairList.zip(uniformPathsOfPotentiallyChangedGraphs, this.getContentIndexCache().getValues(uniformPathsOfPotentiallyChangedGraphs));
        for (Pair pathAndElement : uniformPathsAndTokenElements) {
            TokenElementInfo tokenElement = (TokenElementInfo)((Object)pathAndElement.getSecond());
            if (tokenElement != null) {
                scope.put(tokenElement.getUniformPath(), tokenElement);
                continue;
            }
            Optional<String> originGraphId = potentiallyChangedGraphIds.stream().filter(graphId -> TaintAnalysisUtils.getUniformPathFromMethodIdentifier(graphId).equals(pathAndElement.getFirst())).findAny();
            LOGGER.error("Did not find TokenElementInfo for uniform path: " + (String)pathAndElement.getFirst() + " derived from graphID " + String.valueOf(originGraphId));
        }
        for (String potentiallyChangedUniformPath : uniformPathsOfPotentiallyChangedGraphs) {
            findings.addAll(this.createFindingsForGraphs(sanitizersBySinkType, scope, potentiallyChangedUniformPath));
        }
        return findings;
    }

    private ListMap<String, IndexFinding> createFindingsForGraphs(Map<ETaintSinkType, Set<String>> sanitizersBySinkType, Map<String, TokenElementInfo> scope, String potentiallyChangedUniformPath) throws StorageException, AssertionError {
        ListMap findings = new ListMap();
        findings.addAll((Object)potentiallyChangedUniformPath, new ArrayList());
        for (MethodTaintGraphWithPaths enrichedGraph : this.enrichedTaintGraphIndex.getMethodTaintGraphs(potentiallyChangedUniformPath).values()) {
            for (Map.Entry<Pair<TaintGraphSourceBase, TaintGraphSink>, Set<List<TaintGraphReferenceBase>>> taintPathsEntry : enrichedGraph.getTaintPaths().entrySet()) {
                List<List<TaintGraphReferenceBase>> filteredPaths = TaintAnalysisRunner.filterUnsanitizedPaths(taintPathsEntry.getValue(), sanitizersBySinkType);
                filteredPaths = TaintAnalysisRunner.filterNodesWithoutLocations(filteredPaths);
                TaintGraphSourceBase source = (TaintGraphSourceBase)taintPathsEntry.getKey().getFirst();
                String uniformPath = source.getLocation().getUniformPath();
                Optional<IndexFinding> finding = TaintAnalysisRunner.createFinding(source, (TaintGraphSink)taintPathsEntry.getKey().getSecond(), scope.get(uniformPath), filteredPaths);
                if (!finding.isPresent()) continue;
                findings.add((Object)uniformPath, (Object)finding.get());
            }
        }
        return findings;
    }

    private static List<List<TaintGraphReferenceBase>> filterNodesWithoutLocations(List<List<TaintGraphReferenceBase>> paths) {
        ArrayList<List<TaintGraphReferenceBase>> newPaths = new ArrayList<List<TaintGraphReferenceBase>>();
        for (List<TaintGraphReferenceBase> path : paths) {
            newPaths.add(path.stream().filter(node -> node.getLocation() != null).collect(Collectors.toList()));
        }
        return newPaths;
    }

    private static Map<ETaintSinkType, Set<String>> readSanitizerPatterns(Collection<String> sanitizerPatterns) {
        HashMap<String, ETaintSinkType> nameToSinkType = new HashMap<String, ETaintSinkType>();
        HashMap<ETaintSinkType, Set<String>> patternMap = new HashMap<ETaintSinkType, Set<String>>();
        for (ETaintSinkType type : ETaintSinkType.values()) {
            patternMap.put(type, new HashSet());
            nameToSinkType.put(type.name(), type);
        }
        for (String pattern : sanitizerPatterns) {
            String methodName = StringUtils.getLastPart((String)pattern, (String)":").trim();
            int colonIndex = pattern.indexOf(":");
            if (colonIndex == -1) {
                for (ETaintSinkType type : ETaintSinkType.values()) {
                    ((Set)patternMap.get((Object)type)).add(methodName.toLowerCase());
                }
                continue;
            }
            String typeName = pattern.substring(0, colonIndex);
            if (nameToSinkType.containsKey(typeName)) {
                ((Set)patternMap.get(nameToSinkType.get(typeName))).add(methodName.toLowerCase());
                continue;
            }
            LOGGER.warn("Unknown Sink type name in sanitizer pattern: " + typeName);
        }
        return patternMap;
    }

    private static List<List<TaintGraphReferenceBase>> filterUnsanitizedPaths(Set<List<TaintGraphReferenceBase>> taintPaths, Map<ETaintSinkType, Set<String>> sanitizersBySinkType) {
        if (taintPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<List<TaintGraphReferenceBase>> filteredPaths = new ArrayList<List<TaintGraphReferenceBase>>();
        for (List<TaintGraphReferenceBase> path : taintPaths) {
            CCSMAssert.isInstanceOf((Object)path.get(path.size() - 1), TaintGraphSink.class);
            TaintGraphSink sink = (TaintGraphSink)path.get(path.size() - 1);
            Set<String> sanitizers = sanitizersBySinkType.get((Object)sink.getSinkType());
            boolean skipPath = false;
            for (TaintGraphReferenceBase pathNode : path) {
                if (!(pathNode instanceof MethodCallReturnValueReference) || !TaintAnalysisRunner.isSanitizerCall(((MethodCallReturnValueReference)pathNode).getMethodCallReference(), sanitizers)) continue;
                skipPath = true;
                break;
            }
            if (skipPath) continue;
            filteredPaths.add(path);
        }
        filteredPaths.sort(Comparator.comparing(Object::toString));
        return filteredPaths;
    }

    private static boolean isSanitizerCall(MethodCallReference callReference, Set<String> sanitizers) {
        return sanitizers.contains(callReference.getMethodName().toLowerCase());
    }

    private static Set<String> getGraphsIdsFromCommit(Map<String, MethodTaintGraph> methodTaintGraphIndexEntries, CommitDescriptor commit) {
        HashSet<String> commitEntryKeys = new HashSet<String>();
        for (Map.Entry<String, MethodTaintGraph> entry : methodTaintGraphIndexEntries.entrySet()) {
            if (entry.getValue().getTimestamp() != commit.getTimestamp()) continue;
            commitEntryKeys.add(entry.getKey());
        }
        return commitEntryKeys;
    }

    private static Set<String> buildCallingGraphIdentifierClosure(Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphEntries, Collection<String> changedMethods, Predicate<String> includeGraph, Map<String, Set<String>> callingMethodsMap) {
        HashSet<String> callingGraphIdentifiers = new HashSet<String>(changedMethods);
        callingGraphIdentifiers.addAll(enrichedMethodTaintGraphEntries.entrySet().stream().filter(entry -> includeGraph.test((String)entry.getKey()) && !CollectionUtils.intersectionSet(((MethodTaintGraphWithPaths)entry.getValue()).getInfluencingMethodIdentifiers(), (Collection[])new Collection[]{changedMethods}).isEmpty()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
        ArrayDeque<String> worklist = new ArrayDeque<String>();
        worklist.addAll(callingGraphIdentifiers);
        while (!worklist.isEmpty()) {
            Set callingMethods = callingMethodsMap.getOrDefault(worklist.remove(), Collections.emptySet());
            for (String callingMethod : callingMethods) {
                if (callingGraphIdentifiers.contains(callingMethod) || !includeGraph.test(callingMethod)) continue;
                callingGraphIdentifiers.add(callingMethod);
                worklist.add(callingMethod);
            }
        }
        return callingGraphIdentifiers;
    }

    private static Optional<IndexFinding> createFinding(TaintGraphSourceBase source, TaintGraphSink sink, TokenElementInfo sourceTokenElement, List<List<TaintGraphReferenceBase>> filteredPaths) {
        if (filteredPaths.isEmpty()) {
            return Optional.empty();
        }
        if (sourceTokenElement == null) {
            LOGGER.error("Did not find an ITokenResource in scope for uniform path " + sink.getLocation().getUniformPath() + ". Ignoring taint finding for source " + String.valueOf(source) + ".");
            return Optional.empty();
        }
        if (!sourceTokenElement.getUniformPath().equals(source.getLocation().getUniformPath())) {
            LOGGER.error("ITokenResource " + sourceTokenElement.getUniformPath() + " for source did not match the uniform path of the source " + source.getLocation().getUniformPath() + " Ignoring taint finding for source.");
            return Optional.empty();
        }
        String message = sink.getFindingMessage(source);
        IndexFinding finding = new IndexFinding(TaintAnalysisConfiguration.getFindingGroupName(sink.getSinkType()), "Dataflow", message, source.getLocation());
        finding.setStatementPath(TaintAnalysisRunner.mergeStatementPaths(filteredPaths));
        finding.setProperty("Rule name", (Object)sink.getSinkType().toString());
        return Optional.of(finding);
    }

    private static List<StatementPathElement> mergeStatementPaths(List<List<TaintGraphReferenceBase>> filteredPaths) {
        ArrayList<StatementPathElement> statementPath = new ArrayList<StatementPathElement>();
        HashMap<TaintGraphReferenceBase, Integer> refMap = new HashMap<TaintGraphReferenceBase, Integer>();
        for (List<TaintGraphReferenceBase> path : filteredPaths) {
            for (int i = 0; i < path.size(); ++i) {
                StatementPathElement pathElement;
                TaintGraphReferenceBase reference = path.get(i);
                if (refMap.containsKey(reference)) {
                    pathElement = (StatementPathElement)statementPath.get((Integer)refMap.get(reference));
                } else {
                    pathElement = new StatementPathElement(new HashSet(), reference.getLocation(), reference.toFindingDescription());
                    statementPath.add(pathElement);
                    refMap.put(reference, statementPath.size() - 1);
                }
                if (i <= 0) continue;
                pathElement.addPredecessorPathElement((Integer)refMap.get(path.get(i - 1)));
            }
        }
        return statementPath;
    }
}

