/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.index.dependencies.TypeExtractorBase;
import com.teamscale.index.dependencies.abap.AbapTypeNameUtils;
import com.teamscale.index.dependencies.type.AliasMethodSignature;
import com.teamscale.index.dependencies.type.AttributeDefinition;
import com.teamscale.index.dependencies.type.DetailedMethodSignature;
import com.teamscale.index.dependencies.type.MethodSignature;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.abap.AbapPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.shallowparser.ShallowParserUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapTypeExtractor
extends TypeExtractorBase {
    private static final ITokenMatcher METHOD_MODIFIER_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.REDEFINITION, ETokenType.ABSTRACT});
    private static final EnumSet<ETokenType.ETokenClass> IDENTIFIER_OR_KEYWORD = EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD);
    private static final EnumSet<ETokenType> TYPE_MEMBER_TYPE_ACCESSOR = EnumSet.of(ETokenType.EQGT, ETokenType.ARROW, ETokenType.TILDE);
    private static final Predicate<ShallowEntity> IS_CLASS_OR_INTERFACE_DEFINITION = entity -> CollectionUtils.asHashSet((Object[])new String[]{"class definition", "interface definition"}).contains(entity.getSubtype());
    private static final Predicate<ShallowEntity> IS_TYPES_DEFINITION = entity -> "types".equals(entity.getSubtype());

    @Override
    public List<Type> extractTypes(String uniformPath, String content, ELanguage language) throws ConQATException {
        ArrayList<Type> extractedTypes = new ArrayList<Type>();
        List tokens = ScannerUtils.getTokens((String)content, (ELanguage)language, (String)uniformPath);
        tokens = new AbapPreprocessor().preprocess(uniformPath, tokens);
        List entities = ShallowParserUtils.createParser((ELanguage)language).parseTopLevel(tokens);
        for (ShallowEntity classOrInterfaceDefinition : CollectionUtils.filter((Collection)entities, IS_CLASS_OR_INTERFACE_DEFINITION)) {
            extractedTypes.add(AbapTypeExtractor.buildClassOrInterfaceType(uniformPath, classOrInterfaceDefinition));
        }
        for (ShallowEntity attributeEntity : ShallowEntityTraversalUtils.listMatchingEntitiesRecursive((List)entities, IS_TYPES_DEFINITION)) {
            extractedTypes.add(new Type(AbapTypeNameUtils.buildTypeName(uniformPath, attributeEntity)));
        }
        EAbapObjectType elementType = AbapUtils.createElementNameFromPath((String)uniformPath).getObjectType();
        if (elementType == EAbapObjectType.PROG) {
            for (ShallowEntity classOrInterfaceDefinition : ShallowEntityTraversalUtils.listMatchingEntitiesRecursive((List)entities, IS_CLASS_OR_INTERFACE_DEFINITION)) {
                extractedTypes.add(AbapTypeExtractor.buildClassOrInterfaceType(uniformPath, classOrInterfaceDefinition));
            }
        }
        if (!EnumSet.of(EAbapObjectType.CLAS, EAbapObjectType.INTF).contains(elementType)) {
            extractedTypes.add(new Type(AbapUtils.createElementNameFromPath((String)uniformPath).getUniqueName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        }
        for (ShallowEntity method : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (method.getParent() != null && IS_CLASS_OR_INTERFACE_DEFINITION.test(method.getParent()) || !"function".equals(method.getSubtype())) continue;
            extractedTypes.add(new Type(AbapTypeExtractor.createUniqueFunctionIdentifier(method.getName()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        }
        return CollectionUtils.sort(extractedTypes, Comparator.comparing(Type::getName));
    }

    private static Type buildClassOrInterfaceType(String uniformPath, ShallowEntity classDefinition) throws ConQATException {
        UnmodifiableList classOrInterfaceDefinitionTokens = classDefinition.ownStartTokens();
        int inheritingIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)classOrInterfaceDefinitionTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.INHERITING, ETokenType.FROM});
        List<String> supertypes = Collections.emptyList();
        if (inheritingIndex != -1 && classOrInterfaceDefinitionTokens.size() > inheritingIndex + 2) {
            String supertype = ((IToken)classOrInterfaceDefinitionTokens.get(inheritingIndex + 2)).getText();
            supertypes = Collections.singletonList(supertype);
        }
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        methods.addAll(AbapTypeExtractor.extractMethodDefinitionSignaturesFromClassDefinition(classDefinition));
        methods.addAll(AbapTypeExtractor.extractMethodAliasSignaturesFromClassDefinition(classDefinition));
        String typeName = AbapTypeNameUtils.buildTypeName(uniformPath, classDefinition);
        List<AttributeDefinition> attributes = AbapTypeExtractor.extractAttributesFromClassDefinition(classDefinition);
        return new Type(typeName, attributes, supertypes, methods);
    }

    private static List<AttributeDefinition> extractAttributesFromClassDefinition(ShallowEntity classDefinition) {
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        for (ShallowEntity attributeEntity : ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)classDefinition.getChildren(), (EShallowEntityType)EShallowEntityType.ATTRIBUTE)) {
            Object tokens = attributeEntity.ownStartTokens();
            if (tokens.isEmpty()) continue;
            if (TokenStreamUtils.endsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.DOT})) {
                tokens = tokens.subList(0, tokens.size() - 1);
            }
            if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CLASS_DATA, ETokenType.IDENTIFIER, ETokenType.TYPE}) && !TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.DATA, ETokenType.IDENTIFIER, ETokenType.TYPE})) continue;
            ArrayList<ETokenType> modifiers = new ArrayList<ETokenType>(Collections.singletonList(((IToken)tokens.getFirst()).getType()));
            ArrayList<IToken> typeTokens = new ArrayList<IToken>(CollectionUtils.subListFrom((List)tokens, (int)3));
            modifiers.addAll(AbapTypeExtractor.removeModifierTokens(typeTokens));
            String type = AbapTypeExtractor.extractTypeName(typeTokens);
            String name = ((IToken)tokens.get(1)).getText();
            attributes.add(new AttributeDefinition(name, type, modifiers));
        }
        return attributes;
    }

    private static String extractTypeName(List<IToken> typeTokens) {
        if (typeTokens.size() < 3 && IDENTIFIER_OR_KEYWORD.contains(typeTokens.getFirst().getType().getTokenClass())) {
            return typeTokens.getFirst().getText();
        }
        if (IDENTIFIER_OR_KEYWORD.contains(typeTokens.get(0).getType().getTokenClass()) && TYPE_MEMBER_TYPE_ACCESSOR.contains(typeTokens.get(1).getType()) && IDENTIFIER_OR_KEYWORD.contains(typeTokens.get(2).getType().getTokenClass())) {
            return TokenStreamTextUtils.concatTokenTexts(typeTokens.subList(0, 3), (String)" ").toLowerCase();
        }
        return TokenStreamTextUtils.concatTokenTexts(typeTokens, (String)" ").toLowerCase();
    }

    private static List<ETokenType> removeModifierTokens(List<IToken> typeTokens) {
        ArrayList<ETokenType> modifiers = new ArrayList<ETokenType>();
        if (AbapTypeExtractor.removeSequence(typeTokens, ETokenType.READ_ONLY)) {
            modifiers.add(ETokenType.READ_ONLY);
        }
        if (AbapTypeExtractor.removeSequence(typeTokens, ETokenType.RANGE, ETokenType.OF)) {
            modifiers.add(ETokenType.RANGE);
        }
        if (AbapTypeExtractor.removeSequence(typeTokens, ETokenType.STANDARD, ETokenType.TABLE, ETokenType.OF) || AbapTypeExtractor.removeSequence(typeTokens, ETokenType.SORTED, ETokenType.TABLE, ETokenType.OF) || AbapTypeExtractor.removeSequence(typeTokens, ETokenType.HASHED, ETokenType.TABLE, ETokenType.OF) || AbapTypeExtractor.removeSequence(typeTokens, ETokenType.TABLE, ETokenType.OF)) {
            modifiers.add(ETokenType.TABLE);
        }
        if (AbapTypeExtractor.removeSequence(typeTokens, ETokenType.LINE, ETokenType.OF)) {
            modifiers.add(ETokenType.LINE);
        }
        if (AbapTypeExtractor.removeSequence(typeTokens, ETokenType.REF, ETokenType.TO)) {
            modifiers.add(ETokenType.REF);
        }
        return modifiers;
    }

    private static boolean removeSequence(List<IToken> tokens, ETokenType ... typeSequence) {
        int start = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])typeSequence);
        if (start != -1) {
            int end = start + typeSequence.length;
            if (end > start) {
                tokens.subList(start, end).clear();
            }
            return true;
        }
        return false;
    }

    private static Collection<DetailedMethodSignature> extractMethodDefinitionSignaturesFromClassDefinition(ShallowEntity classDefinition) {
        ArrayList<DetailedMethodSignature> methods = new ArrayList<DetailedMethodSignature>();
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)classDefinition.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (!"method declaration".equals(methodEntity.getSubtype())) continue;
            List parameters = LanguageFeatureParser.ABAP.getTypeInfoForMethodParameters(methodEntity, (List)methodEntity.includedTokens());
            List modifiers = CollectionUtils.map((Collection)TokenStreamUtils.findAll((List)methodEntity.ownStartTokens(), (ITokenMatcher)METHOD_MODIFIER_TOKEN_TYPES), index -> ((IToken)methodEntity.ownStartTokens().get(index.intValue())).getType());
            methods.add(new DetailedMethodSignature(methodEntity.getName(), modifiers, null, parameters, MethodSignature.EMethodType.METHOD));
        }
        return methods;
    }

    private static Collection<AliasMethodSignature> extractMethodAliasSignaturesFromClassDefinition(ShallowEntity classDefinition) {
        ArrayList<AliasMethodSignature> methods = new ArrayList<AliasMethodSignature>();
        for (ShallowEntity aliasStatement : ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)classDefinition.getChildren(), (EShallowEntityType)EShallowEntityType.META)) {
            if (!TokenStreamUtils.hasTokenTypeSequence((List)aliasStatement.ownStartTokens(), (int)0, (ETokenType[])new ETokenType[]{ETokenType.ALIASES, ETokenType.IDENTIFIER, ETokenType.FOR, ETokenType.IDENTIFIER, ETokenType.TILDE, ETokenType.IDENTIFIER, ETokenType.DOT})) continue;
            String implementedMethodName = ((IToken)aliasStatement.ownStartTokens().get(1)).getText();
            String interfaceName = ((IToken)aliasStatement.ownStartTokens().get(3)).getText();
            String interfaceMethodName = ((IToken)aliasStatement.ownStartTokens().get(5)).getText();
            methods.add(new AliasMethodSignature(implementedMethodName, interfaceName, interfaceMethodName));
        }
        return methods;
    }

    public static String createUniqueFunctionIdentifier(String functionName) {
        return functionName.toUpperCase() + "@function";
    }
}

