/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.php;

import com.teamscale.index.dependencies.php.PhpShallowEntityVisitorBase;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class TypeExtractingPhpShallowEntityVisitor
extends PhpShallowEntityVisitorBase {
    private final List<String> types = new ArrayList<String>();

    @Override
    public boolean visit(ShallowEntity entity) {
        switch (entity.getType()) {
            case METHOD: 
            case TYPE: {
                this.addQualifiedType(entity.getName());
                return false;
            }
            case STATEMENT: {
                UnmodifiableList tokens = entity.ownStartTokens();
                int index = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.CONST);
                if (index >= 0 && index + 1 < tokens.size()) {
                    this.addQualifiedType(((IToken)tokens.get(index + 1)).getText());
                }
                return false;
            }
        }
        return super.visit(entity);
    }

    private void addQualifiedType(String type) {
        this.types.add(this.getQualifiedName(type));
    }

    public List<String> getTypes() {
        return CollectionUtils.asUnmodifiable(this.types);
    }
}

