/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisCommitStatus;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisShortStatusInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndexUtils;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LockableIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="external-analysis-status", options={EStorageOption.COMPRESSED, EStorageOption.COMMIT_ISOLATED}, valueClasses={ExternalAnalysisStatusInfo.class})
public class ExternalAnalysisStatusIndex
extends LockableIndex<LockedIndexAccess>
implements IProjectIndex,
IRollbackableIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String INDEX_NAME = "external-analysis-status";

    public ExternalAnalysisStatusIndex(IStore store) {
        super(store);
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        this.runWithLock(lockedIndex -> lockedIndex.performRollback(timestampByBranch));
    }

    protected LockedIndexAccess getIndexAccess(IStore store) {
        return new LockedIndexAccess(store);
    }

    public static final class LockedIndexAccess {
        private static final int MAX_MESSAGE_LENGTH = 100;
        private static final byte[] SHORT_INFO_KEY_PREFIX = new byte[]{2};
        private static final byte[] DETAILED_STATUS_KEY_PREFIX = new byte[]{3};
        private final IStore store;

        private LockedIndexAccess(IStore store) {
            this.store = store;
        }

        public List<ExternalAnalysisPartitionInfo> getPartitionInfos() throws StorageException {
            CounterSet partitionCounts = new CounterSet();
            CounterSet partitionPendingCounts = new CounterSet();
            CounterSet partitionErrorCounts = new CounterSet();
            this.store.scan(SHORT_INFO_KEY_PREFIX, (key, value) -> {
                block12: {
                    byte[] prefix = (byte[])ByteArrayUtils.split((byte[])key, (byte[])CommitDescriptor.SEPARATOR, (int)2).getFirst();
                    String partition = StringUtils.bytesToString((byte[])Arrays.copyOfRange(prefix, SHORT_INFO_KEY_PREFIX.length, prefix.length));
                    CounterSet counterSet = partitionCounts;
                    synchronized (counterSet) {
                        partitionCounts.inc((Object)partition);
                    }
                    try {
                        ExternalAnalysisShortStatusInfo shortInfo = (ExternalAnalysisShortStatusInfo)StorageUtils.deserialize((byte[])value);
                        if (EExternalAnalysisProcessingStatus.isPendingStatus(shortInfo.getLatestStatus())) {
                            CounterSet counterSet2 = partitionPendingCounts;
                            synchronized (counterSet2) {
                                partitionPendingCounts.inc((Object)partition);
                                break block12;
                            }
                        }
                        if (!shortInfo.hasErrors()) break block12;
                        CounterSet counterSet3 = partitionErrorCounts;
                        synchronized (counterSet3) {
                            partitionErrorCounts.inc((Object)partition);
                        }
                    }
                    catch (StorageException e) {
                        LOGGER.warn("Could not determine counts for external analysis partition", (Throwable)e);
                    }
                }
            });
            return CollectionUtils.map(partitionCounts.toMap().entrySet(), entry -> new ExternalAnalysisPartitionInfo((String)entry.getKey(), (Integer)entry.getValue(), partitionErrorCounts.getValue((Object)((String)entry.getKey())), partitionPendingCounts.getValue((Object)((String)entry.getKey()))));
        }

        public PairList<CommitDescriptor, ExternalAnalysisShortStatusInfo> getCommitsForPartition(String partition) throws StorageException {
            final PairList result = new PairList();
            byte[] prefix = ByteArrayUtils.concat((byte[][])new byte[][]{SHORT_INFO_KEY_PREFIX, StringUtils.stringToBytes((String)partition), CommitDescriptor.SEPARATOR});
            ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){

                protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                    byte[] commitPart = (byte[])ByteArrayUtils.split((byte[])key, (byte[])CommitDescriptor.SEPARATOR, (int)2).get(1);
                    result.add((Object)CommitDescriptor.fromTimestampBranchKey((byte[])commitPart), (Object)((ExternalAnalysisShortStatusInfo)StorageUtils.deserialize((byte[])value)));
                }
            };
            this.store.scan(prefix, (IKeyValueCallback)callback);
            callback.throwCaughtException();
            return result;
        }

        public @Nullable ExternalAnalysisStatusInfo getStatus(CommitDescriptor commit) throws StorageException {
            return (ExternalAnalysisStatusInfo)StorageUtils.deserialize((byte[])this.store.get(LockedIndexAccess.makeDetailedStatusKey(commit)));
        }

        public List<@Nullable ExternalAnalysisStatusInfo> getStatus(List<? extends CommitDescriptor> commits) throws StorageException {
            List keys = CollectionUtils.map(commits, LockedIndexAccess::makeDetailedStatusKey);
            return StorageUtils.deserializeValues((List)this.store.get(keys));
        }

        public <T extends CommitDescriptor> ListMap<String, ExternalAnalysisCommitStatus> getExternalAnalysisUploadsPerPartition(List<String> partitions, List<T> commits) throws StorageException {
            ArrayList<Pair> partitionAndCommits = new ArrayList<Pair>();
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            for (String partition : partitions) {
                for (CommitDescriptor commitDescriptor : commits) {
                    partitionAndCommits.add(new Pair((Object)partition, (Object)commitDescriptor));
                    keys.add(LockedIndexAccess.makeShortInfoKey(commitDescriptor, partition));
                }
            }
            List values = this.store.get(keys);
            List externalAnalysisShortStatusInfos = StorageUtils.deserializeValues((List)values);
            ListMap externalUploadsPerPartition = new ListMap();
            CollectionUtils.forEach(partitionAndCommits, (Iterable)externalAnalysisShortStatusInfos, (partitionAndCommit, externalAnalysisShortStatusInfo) -> {
                if (externalAnalysisShortStatusInfo == null) {
                    return;
                }
                externalUploadsPerPartition.add((Object)((String)partitionAndCommit.getFirst()), (Object)new ExternalAnalysisCommitStatus((CommitDescriptor)partitionAndCommit.getSecond(), (ExternalAnalysisShortStatusInfo)externalAnalysisShortStatusInfo));
            });
            return externalUploadsPerPartition;
        }

        private static byte[] makeDetailedStatusKey(CommitDescriptor commit) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{DETAILED_STATUS_KEY_PREFIX, commit.toBranchTimestampKeyWithSeparator()});
        }

        private static byte[] makeShortInfoKey(CommitDescriptor commit, String partition) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{SHORT_INFO_KEY_PREFIX, StringUtils.stringToBytes((String)partition), CommitDescriptor.SEPARATOR, commit.toTimestampBranchKey()});
        }

        public void updateStatus(ExternalAnalysisStatusInfo status) throws StorageException {
            this.updateStatusWithKnownOldStatus(this.getStatus(status.getCommit()), status);
        }

        public void updateStatusWithKnownOldStatus(@Nullable ExternalAnalysisStatusInfo oldStatus, ExternalAnalysisStatusInfo status) throws StorageException {
            this.updateStatuses((PairList<ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo>)PairList.from((Object)oldStatus, (Object)status));
        }

        public void updateStatuses(PairList<@Nullable ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo> oldAndNewStatuses) throws StorageException {
            ArrayList partitionKeysToRemove = new ArrayList();
            PairList putValues = new PairList();
            for (Pair oldAndNewStatus : oldAndNewStatuses) {
                if (oldAndNewStatus.getFirst() != null) {
                    HashSet partitionsToRemove = CollectionUtils.differenceSet(((ExternalAnalysisStatusInfo)oldAndNewStatus.getFirst()).getPartitions(), (Collection[])new Collection[]{((ExternalAnalysisStatusInfo)oldAndNewStatus.getSecond()).getPartitions()});
                    partitionKeysToRemove.addAll(CollectionUtils.map((Collection)partitionsToRemove, partition -> LockedIndexAccess.makeShortInfoKey(((ExternalAnalysisStatusInfo)oldAndNewStatus.getSecond()).getCommit(), partition)));
                }
                putValues.addAll(LockedIndexAccess.getEntriesForUpdatedStatus((ExternalAnalysisStatusInfo)oldAndNewStatus.getSecond()));
            }
            this.store.remove(partitionKeysToRemove);
            this.store.put(putValues);
        }

        public void removeStatus(ExternalAnalysisStatusInfo status) throws StorageException {
            this.store.remove(LockedIndexAccess.determineKeysToDeleteForStatus(status));
        }

        public void removeStatuses(List<@Nullable ExternalAnalysisStatusInfo> statuses) throws StorageException {
            List keysToRemove = statuses.stream().filter(Objects::nonNull).map(LockedIndexAccess::determineKeysToDeleteForStatus).flatMap(Collection::stream).toList();
            this.store.remove(keysToRemove);
        }

        private static List<byte[]> determineKeysToDeleteForStatus(ExternalAnalysisStatusInfo status) {
            List keys = CollectionUtils.map(status.getPartitions(), partition -> LockedIndexAccess.makeShortInfoKey(status.getCommit(), partition));
            keys.add(LockedIndexAccess.makeDetailedStatusKey(status.getCommit()));
            return keys;
        }

        private static PairList<byte[], byte[]> getEntriesForUpdatedStatus(ExternalAnalysisStatusInfo statusInfo) throws StorageException {
            PairList keysValues = new PairList();
            keysValues.add((Object)LockedIndexAccess.makeDetailedStatusKey(statusInfo.getCommit()), (Object)StorageUtils.serialize((Serializable)statusInfo));
            byte[] shortInfo = StorageUtils.serialize((Serializable)LockedIndexAccess.deriveShortInfo(statusInfo));
            for (String partition : statusInfo.getPartitions()) {
                keysValues.add((Object)LockedIndexAccess.makeShortInfoKey(statusInfo.getCommit(), partition), (Object)shortInfo);
            }
            return keysValues;
        }

        private static ExternalAnalysisShortStatusInfo deriveShortInfo(ExternalAnalysisStatusInfo status) {
            boolean hasErrors = false;
            EExternalAnalysisProcessingStatus latestStatus = null;
            for (ExternalAnalysisProcessingStepInfo step : status.getProcessingSteps()) {
                hasErrors = hasErrors || !step.isSuccessful();
                latestStatus = step.getStatus();
            }
            String message = StringUtils.truncateWithThreeDots((String)status.getMessage(), (int)100);
            return new ExternalAnalysisShortStatusInfo(hasErrors, message, latestStatus, status.isUpload(), status.getUploadTimestamp(), status.isStoredExternally());
        }

        private void performRollback(Map<String, Long> timestampByBranch) throws StorageException {
            List statusKeysToRollBack = Collections.synchronizedList(new ArrayList());
            for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
                byte[] beginKey = LockedIndexAccess.makeDetailedStatusKey(new CommitDescriptor(entry.getKey(), entry.getValue() + 1L));
                byte[] endKey = LockedIndexAccess.makeDetailedStatusKey(new CommitDescriptor(entry.getKey(), Long.MAX_VALUE));
                this.store.scanKeys(beginKey, endKey, (key, value) -> statusKeysToRollBack.add(key));
            }
            ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
            PairList keysToUpdate = new PairList();
            for (byte[] rawStatus : this.store.get(statusKeysToRollBack)) {
                ExternalAnalysisStatusInfo statusInfo = (ExternalAnalysisStatusInfo)StorageUtils.deserialize((byte[])rawStatus);
                if (statusInfo.isUpload()) {
                    ExternalAnalysisStatusIndexUtils.removeReanalyzableProcessingStepsFromUpload(statusInfo);
                    keysToUpdate.addAll(LockedIndexAccess.getEntriesForUpdatedStatus(statusInfo));
                    continue;
                }
                keysToDelete.addAll(LockedIndexAccess.determineKeysToDeleteForStatus(statusInfo));
            }
            this.store.remove(keysToDelete);
            this.store.put(keysToUpdate);
        }
    }
}

