/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsDeletionFilterUtils;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.index.dependencies.ExternalDependencyIndex;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.result.ExternalAnalysisResultDependencyInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultFindings;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResultProbeCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultFindingsProcessor;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testcoverage.McDcCoverableAnalyzer;
import com.teamscale.index.testcoverage.ProbeCoverageIndex;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestCoverageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class ExternalAnalysisResultsUpdater
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex newContentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="content")
    private TokenElementIndex oldContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private LineCoverageIndex lineCoverageIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProbeCoverageIndex probeCoverageIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalDependencyIndex dependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalAnalysisPartitionIndex externalAnalysisPartitionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalAnalysisResultIndex externalAnalysisResultIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex elementHistoryIndex;
    private boolean shouldUpdateProbeCoverage = true;
    private FindingsSchema findingsSchema;

    public void execute() throws StorageException {
        List<String> partitions = this.externalAnalysisPartitionIndex.getAllPartitions();
        if (partitions.isEmpty()) {
            return;
        }
        this.findingsSchema = this.findingsSchemaIndex.getFindingsSchema();
        this.shouldUpdateProbeCoverage = this.isMcDcCoverageMetricEnabled();
        List files = this.contentDelta.getAddedOrChangedKeysAsStrings();
        List<TokenElementInfo> oldContents = this.oldContentIndex.getTokenElements(files);
        List<TokenElementInfo> newContents = this.newContentIndex.getTokenElements(files);
        Map<String, LocationAdjuster> newFileToLocationAdjuster = ExternalAnalysisResultsUpdater.computeLocationAdjusters(files, oldContents, newContents);
        for (String partition : partitions) {
            this.updateExternalAnalysisResults(partition, files, newContents, newFileToLocationAdjuster);
        }
    }

    private static @NonNull Map<String, LocationAdjuster> computeLocationAdjusters(List<String> files, List<TokenElementInfo> oldContents, List<TokenElementInfo> newContents) {
        HashMap<String, LocationAdjuster> newFileToLocationAdjuster = new HashMap<String, LocationAdjuster>();
        for (int i = 0; i < files.size(); ++i) {
            TokenElementInfo oldContent = oldContents.get(i);
            if (oldContent == null) continue;
            TokenElementInfo newElementInfo = newContents.get(i);
            String uniformPath = files.get(i);
            CCSMAssert.isNotNull((Object)((Object)newElementInfo), (String)("File from delta is missing: " + uniformPath));
            LocationAdjuster locationAdjuster = new LocationAdjuster(oldContent.getText(), newElementInfo.getText());
            newFileToLocationAdjuster.put(uniformPath, locationAdjuster);
        }
        return newFileToLocationAdjuster;
    }

    private boolean isMcDcCoverageMetricEnabled() throws StorageException {
        MetricDirectorySchema metricSchema = this.metricSchemaIndex.getPublicSchema();
        CCSMAssert.isNotNull((Object)metricSchema, (String)"The retrieved metric schema must not be null");
        for (MetricDirectorySchemaEntry entry : metricSchema.getAllEntries()) {
            if (!"MC/DC Coverage".equals(entry.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateExternalAnalysisResults(String resultsPartition, List<String> files, List<TokenElementInfo> newContents, Map<String, LocationAdjuster> newFileToLocationAdjuster) throws StorageException, AssertionError {
        String findingsPartition = ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition(resultsPartition);
        List existingFindings = this.findingsIndex.getFindings(findingsPartition, files);
        List existingLineCoverageInfos = this.lineCoverageIndex.getCoverageInfos(resultsPartition, files);
        List existingProbeCoverageInfos = this.probeCoverageIndex.getCoverageInfos(resultsPartition, files);
        List<ExternalDependencyInfo> existingDependencyInfos = this.dependencyIndex.getDependencyInfoForFiles(resultsPartition, files);
        PairList allUpdatedFindings = new PairList();
        PairList allUpdatedLineCoverageInfos = new PairList();
        PairList allUpdatedProbeCoverageInfos = new PairList();
        PairList allUpdatedDependencyInfos = new PairList();
        PairList newFiles = new PairList();
        for (int i = 0; i < files.size(); ++i) {
            String uniformPath = files.get(i);
            LocationAdjuster locationAdjuster = newFileToLocationAdjuster.get(uniformPath);
            if (locationAdjuster == null) {
                newFiles.add((Object)files.get(i), (Object)newContents.get(i));
                continue;
            }
            this.updateExternalResultsForElement(resultsPartition, uniformPath, locationAdjuster, (ArrayList)existingFindings.get(i), (LineCoverageInfo)existingLineCoverageInfos.get(i), (ProbeCoverageInfo)existingProbeCoverageInfos.get(i), existingDependencyInfos.get(i), newContents.get(i), (PairList<String, List<IndexFinding>>)allUpdatedFindings, (PairList<String, LineCoverageInfo>)allUpdatedLineCoverageInfos, (PairList<String, ProbeCoverageInfo>)allUpdatedProbeCoverageInfos, (PairList<String, ExternalDependencyInfo>)allUpdatedDependencyInfos);
        }
        this.extractExternalAnalysisResultsForNewFiles(resultsPartition, (PairList<String, TokenElementInfo>)newFiles, (PairList<String, List<IndexFinding>>)allUpdatedFindings, (PairList<String, LineCoverageInfo>)allUpdatedLineCoverageInfos, (PairList<String, ProbeCoverageInfo>)allUpdatedProbeCoverageInfos, (PairList<String, ExternalDependencyInfo>)allUpdatedDependencyInfos);
        this.persistResults(resultsPartition, (PairList<String, List<IndexFinding>>)allUpdatedFindings, (PairList<String, LineCoverageInfo>)allUpdatedLineCoverageInfos, (PairList<String, ProbeCoverageInfo>)allUpdatedProbeCoverageInfos, (PairList<String, ExternalDependencyInfo>)allUpdatedDependencyInfos);
    }

    private void extractExternalAnalysisResultsForNewFiles(String resultsPartition, PairList<String, TokenElementInfo> newFiles, PairList<String, List<IndexFinding>> allUpdatedFindings, PairList<String, LineCoverageInfo> allUpdatedLineCoverageInfos, PairList<String, ProbeCoverageInfo> allUpdatedProbeCoverageInfos, PairList<String, ExternalDependencyInfo> allUpdatedDependencyInfos) throws StorageException {
        if (newFiles.isEmpty()) {
            return;
        }
        List uniformPaths = newFiles.extractFirstList();
        Map<String, String> originPathMapping = this.obtainOriginPathMapping(uniformPaths);
        Map<String, TokenElementInfo> originPathToElement = ExternalAnalysisResultsUpdater.getPathToElementMapping(this.oldContentIndex, originPathMapping.values());
        ExternalAnalysisResultsUpdater.removeEntriesWithoutAssociatedElements(originPathMapping, originPathToElement);
        Map<String, ExternalAnalysisResults> existingResultsByPath = this.buildExistingResultsByPathMapping(resultsPartition, new ArrayList<String>(CollectionUtils.unionSet((Collection)uniformPaths, (Collection[])new Collection[]{originPathMapping.values()})));
        for (int i = 0; i < newFiles.size(); ++i) {
            String uniformPath = (String)newFiles.getFirst(i);
            TokenElementInfo tokenElement = (TokenElementInfo)((Object)newFiles.getSecond(i));
            Pair<ExternalAnalysisResults, LocationAdjuster> existingResultsWithAdjuster = ExternalAnalysisResultsUpdater.getExistingResultsWithAdjuster(existingResultsByPath, tokenElement, originPathMapping, originPathToElement);
            if (existingResultsWithAdjuster == null) continue;
            ExternalAnalysisResults existingResults = (ExternalAnalysisResults)existingResultsWithAdjuster.getFirst();
            LocationAdjuster adjuster = (LocationAdjuster)existingResultsWithAdjuster.getSecond();
            ExternalAnalysisResultsUpdater.extractFindingsForNewFiles(allUpdatedFindings, existingResults, tokenElement, adjuster, uniformPath);
            ExternalAnalysisResultsUpdater.extractLineCoverageForNewFiles(allUpdatedLineCoverageInfos, existingResults, adjuster, uniformPath);
            ExternalAnalysisResultsUpdater.extractProbeCoverageForNewFiles(allUpdatedProbeCoverageInfos, existingResults, adjuster, uniformPath);
            ExternalAnalysisResultsUpdater.extractDependencyInfosForNewFiles(allUpdatedDependencyInfos, existingResults, adjuster, uniformPath);
        }
    }

    private static void removeEntriesWithoutAssociatedElements(Map<String, String> originPathMapping, Map<String, TokenElementInfo> originPathToElement) {
        List<Map.Entry> entriesWithMissingElements = originPathMapping.entrySet().stream().filter(entry -> !originPathToElement.containsKey(entry.getValue())).toList();
        for (Map.Entry entryWithMissingElement : entriesWithMissingElements) {
            LOGGER.error("Could not find element for uniform path " + (String)entryWithMissingElement.getValue() + " (origin of " + (String)entryWithMissingElement.getKey() + "). Skipping this element.");
            originPathMapping.remove(entryWithMissingElement.getKey());
        }
    }

    private static Pair<ExternalAnalysisResults, LocationAdjuster> getExistingResultsWithAdjuster(Map<String, ExternalAnalysisResults> existingResultsByPath, TokenElementInfo tokenElement, Map<String, String> originPathMapping, Map<String, TokenElementInfo> originPathToElement) {
        ExternalAnalysisResults existingResults = existingResultsByPath.get(tokenElement.getUniformPath());
        if (existingResults == null && originPathMapping.containsKey(tokenElement.getUniformPath())) {
            String originPath = originPathMapping.get(tokenElement.getUniformPath());
            existingResults = existingResultsByPath.get(originPath);
            if (existingResults == null) {
                return null;
            }
            return new Pair((Object)existingResults, (Object)new LocationAdjuster(originPathToElement.get(originPath).getText(), tokenElement.getText(), tokenElement.getUniformPath()));
        }
        if (existingResults == null) {
            return null;
        }
        return new Pair((Object)existingResults, (Object)new LocationAdjuster(tokenElement.getText(), tokenElement.getText()));
    }

    private static Map<String, TokenElementInfo> getPathToElementMapping(TokenElementIndex tokenElementIndex, Collection<String> uniformPaths) throws StorageException {
        return tokenElementIndex.getTokenElementsByUniformPath(uniformPaths);
    }

    private Map<String, ExternalAnalysisResults> buildExistingResultsByPathMapping(String resultsPartition, List<String> allPaths) throws StorageException {
        List<ExternalAnalysisResults> existingResultsList = this.externalAnalysisResultIndex.getAnalysisResults(resultsPartition, allPaths);
        HashMap<String, ExternalAnalysisResults> existingResultsByPath = new HashMap<String, ExternalAnalysisResults>();
        for (int i = 0; i < existingResultsList.size(); ++i) {
            if (existingResultsList.get(i) == null || existingResultsList.get(i).isEmpty()) continue;
            existingResultsByPath.put(allPaths.get(i), existingResultsList.get(i));
        }
        return existingResultsByPath;
    }

    private Map<String, String> obtainOriginPathMapping(List<String> uniformPaths) throws StorageException {
        String currentBranchName = this.getSchedulingCommit().getBranchName();
        List<ElementHistoryEntry> elementHistoryEntries = this.elementHistoryIndex.getHistoryEntries(uniformPaths);
        HashMap<String, String> originPaths = new HashMap<String, String>();
        for (int i = 0; i < elementHistoryEntries.size(); ++i) {
            ElementHistoryEntry elementHistoryEntry = elementHistoryEntries.get(i);
            if (elementHistoryEntry == null || elementHistoryEntry.getOriginPath() == null || elementHistoryEntry.getOriginCommit() == null || !currentBranchName.equals(elementHistoryEntry.getOriginCommit().getBranchName()) || elementHistoryEntry.getChangeType() == EElementHistoryChangeType.COPY) continue;
            originPaths.put(uniformPaths.get(i), elementHistoryEntry.getOriginPath());
        }
        return originPaths;
    }

    private static void extractFindingsForNewFiles(PairList<String, List<IndexFinding>> allUpdatedFindings, ExternalAnalysisResults existingResults, TokenElementInfo newFile, LocationAdjuster adjuster, String uniformPath) {
        for (ExternalAnalysisResultFindings existingResult : existingResults.getByType(ExternalAnalysisResultFindings.class)) {
            List<IndexFinding> findings = ExternalAnalysisResultsUpdater.adjustAndFilterFindings(newFile, adjuster, (List<IndexFinding>)existingResult.getData());
            allUpdatedFindings.add((Object)uniformPath, new ArrayList<IndexFinding>(findings));
        }
    }

    private static void extractLineCoverageForNewFiles(PairList<String, LineCoverageInfo> allUpdatedLineCoverageInfos, ExternalAnalysisResults existingResults, LocationAdjuster adjuster, String uniformPath) {
        for (ExternalAnalysisResultLineCoverage existingResult : existingResults.getByType(ExternalAnalysisResultLineCoverage.class)) {
            LineCoverageInfo lineCoverage = TestCoverageUtils.adjustCoverageInfo((LineCoverageInfo)existingResult.getData(), (ILineAdjuster)adjuster, (String)"", (boolean)false);
            allUpdatedLineCoverageInfos.add((Object)uniformPath, (Object)lineCoverage);
        }
    }

    private static void extractProbeCoverageForNewFiles(PairList<String, ProbeCoverageInfo> allUpdatedProbeCoverageInfos, ExternalAnalysisResults existingResults, LocationAdjuster adjuster, String uniformPath) {
        for (ExternalAnalysisResultProbeCoverage existingResult : existingResults.getByType(ExternalAnalysisResultProbeCoverage.class)) {
            TestCoverageUtils.adjustProbeBasedCoverage((ProbeCoverageInfo)existingResult.getData(), (LocationAdjuster)adjuster, (String)"", (boolean)false);
            allUpdatedProbeCoverageInfos.add((Object)uniformPath, (Object)existingResult.getData());
        }
    }

    private static void extractDependencyInfosForNewFiles(PairList<String, ExternalDependencyInfo> allUpdatedDependencyInfos, ExternalAnalysisResults existingResults, LocationAdjuster adjuster, String uniformPath) {
        for (ExternalAnalysisResultDependencyInfo existingResult : existingResults.getByType(ExternalAnalysisResultDependencyInfo.class)) {
            ExternalAnalysisResultsUpdater.adjustDependencyInfo(existingResult.getData(), adjuster);
            allUpdatedDependencyInfos.add((Object)uniformPath, (Object)existingResult.getData());
        }
    }

    private static List<IndexFinding> adjustAndFilterFindings(TokenElementInfo tokenElement, LocationAdjuster adjuster, List<IndexFinding> findings) {
        findings = IndexFindingUtils.adjustFindingLocations((LocationAdjuster)adjuster, findings, oldFinding -> new IndexFinding(oldFinding));
        findings = FindingsDeletionFilterUtils.filterFindings((List)findings, (List)tokenElement.getFilterDeletions(), (int)tokenElement.getText().length());
        return findings;
    }

    private void updateExternalResultsForElement(String partition, String uniformPath, LocationAdjuster locationAdjuster, ArrayList<IndexFinding> oldFindings, LineCoverageInfo oldLineCoverage, ProbeCoverageInfo oldProbeCoverage, ExternalDependencyInfo oldDependencies, TokenElementInfo newElementInfo, PairList<String, List<IndexFinding>> allUpdatedFindings, PairList<String, LineCoverageInfo> allUpdatedLineCoverageInfos, PairList<String, ProbeCoverageInfo> allUpdatedProbeCoverageInfos, PairList<String, ExternalDependencyInfo> allUpdatedDependencyInfos) {
        if (oldFindings != null && !oldFindings.isEmpty()) {
            ArrayList adjustedFindings = new ArrayList(CollectionUtils.filter(oldFindings, finding -> finding.getAnalysisTimestamp() == this.getSchedulingCommit().getTimestamp()));
            oldFindings = new ArrayList(CollectionUtils.filter(oldFindings, finding -> finding.getAnalysisTimestamp() != this.getSchedulingCommit().getTimestamp()));
            adjustedFindings.addAll(IndexFindingUtils.adjustFindingLocations((LocationAdjuster)locationAdjuster, oldFindings, oldFinding -> new IndexFinding(oldFinding)));
            List filteredFindings = FindingsDeletionFilterUtils.filterFindings(adjustedFindings, (List)newElementInfo.getFilterDeletions(), (int)newElementInfo.getText().length());
            allUpdatedFindings.add((Object)uniformPath, (Object)filteredFindings);
        }
        ExternalAnalysisResultsUpdater.updateDependenciesForElement(uniformPath, oldDependencies, allUpdatedDependencyInfos, locationAdjuster);
        this.updateLineCoverageForElement(partition, uniformPath, oldLineCoverage, allUpdatedLineCoverageInfos, locationAdjuster);
        this.updateProbeCoverageForElement(partition, uniformPath, oldProbeCoverage, newElementInfo, allUpdatedProbeCoverageInfos, locationAdjuster);
    }

    private static void updateDependenciesForElement(String uniformPath, ExternalDependencyInfo oldDependencies, PairList<String, ExternalDependencyInfo> allUpdatedDependencyInfos, LocationAdjuster locationAdjuster) {
        if (oldDependencies != null) {
            ExternalAnalysisResultsUpdater.adjustDependencyInfo(oldDependencies, locationAdjuster);
            allUpdatedDependencyInfos.add((Object)uniformPath, (Object)oldDependencies);
        }
    }

    private static void adjustDependencyInfo(ExternalDependencyInfo oldDependencies, LocationAdjuster locationAdjuster) {
        for (ExternalDependencyInfo.Dependency dependency : oldDependencies.getDependencies()) {
            ArrayList<TextRegionLocation> locations = new ArrayList<TextRegionLocation>(dependency.getLocations());
            dependency.getLocations().clear();
            for (TextRegionLocation location : locations) {
                dependency.getLocations().add(locationAdjuster.adjustLocation(location));
            }
        }
    }

    private void updateLineCoverageForElement(String partition, String uniformPath, LineCoverageInfo oldLineCoverage, PairList<String, LineCoverageInfo> allUpdatedLineCoverageInfos, LocationAdjuster locationAdjuster) {
        if (oldLineCoverage != null && oldLineCoverage.getUploadCommitTimestamp() == this.getSchedulingCommit().getTimestamp()) {
            allUpdatedLineCoverageInfos.add((Object)uniformPath, (Object)oldLineCoverage);
        } else if (oldLineCoverage != null) {
            StringBuilder jobInfo = new StringBuilder("Updating line coverage in partition '" + partition + "'");
            if (!LineCoverageInfo.isUndefinedTimestamp((long)oldLineCoverage.getUploadCommitTimestamp())) {
                jobInfo.append(" with timestamp ").append(oldLineCoverage.getUploadCommitTimestamp()).append(" (").append(new Date(oldLineCoverage.getUploadCommitTimestamp())).append(")");
            }
            jobInfo.append(" for ").append(uniformPath);
            LOGGER.info(jobInfo.toString());
            allUpdatedLineCoverageInfos.add((Object)uniformPath, (Object)TestCoverageUtils.adjustCoverageInfo((LineCoverageInfo)oldLineCoverage, (ILineAdjuster)locationAdjuster, (String)jobInfo.toString()));
        }
    }

    private void updateProbeCoverageForElement(String partition, String uniformPath, ProbeCoverageInfo oldProbeCoverage, TokenElementInfo newElementInfo, PairList<String, ProbeCoverageInfo> allUpdatedProbeCoverageInfos, LocationAdjuster locationAdjuster) {
        if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(newElementInfo.getLanguage()) || !this.shouldUpdateProbeCoverage) {
            return;
        }
        if (oldProbeCoverage != null) {
            String jobInfo = "Updating probe coverage in partition " + partition + " for " + uniformPath;
            LOGGER.info(jobInfo);
            TestCoverageUtils.adjustProbeBasedCoverage((ProbeCoverageInfo)oldProbeCoverage, (LocationAdjuster)locationAdjuster, (String)jobInfo);
            allUpdatedProbeCoverageInfos.add((Object)uniformPath, (Object)oldProbeCoverage);
        } else {
            McDcCoverableAnalyzer.analyze(newElementInfo).ifPresent(coverableProbeCoverage -> allUpdatedProbeCoverageInfos.add((Object)uniformPath, coverableProbeCoverage));
        }
    }

    private void persistResults(String resultsPartition, PairList<String, List<IndexFinding>> allUpdatedFindings, PairList<String, LineCoverageInfo> allUpdatedLineCoverageInfos, PairList<String, ProbeCoverageInfo> allUpdatedProbeCoverageInfos, PairList<String, ExternalDependencyInfo> allUpdatedDependencyInfos) throws StorageException {
        String findingsPartition = ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition(resultsPartition);
        if (!allUpdatedFindings.isEmpty()) {
            this.findingsIndex.setFindings(findingsPartition, allUpdatedFindings, this.findingsSchema);
        }
        if (!allUpdatedLineCoverageInfos.isEmpty()) {
            this.lineCoverageIndex.setCoverageInfos(resultsPartition, allUpdatedLineCoverageInfos);
        }
        if (!allUpdatedProbeCoverageInfos.isEmpty()) {
            this.probeCoverageIndex.setCoverageInfos(resultsPartition, allUpdatedProbeCoverageInfos);
        }
        if (!allUpdatedDependencyInfos.isEmpty()) {
            this.dependencyIndex.setDependencyInfos(resultsPartition, allUpdatedDependencyInfos);
        }
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            List deletedKeysAsStrings = this.contentDelta.getDeletedKeysAsStrings();
            this.findingsIndex.removeFindingsForPartitionsAndPaths(findingsPartition, deletedKeysAsStrings);
            this.lineCoverageIndex.removeCoverageInfos(resultsPartition, deletedKeysAsStrings);
            this.probeCoverageIndex.removeCoverageInfos(resultsPartition, deletedKeysAsStrings);
            this.dependencyIndex.removeDependencyInfos(resultsPartition, deletedKeysAsStrings);
        }
    }
}

