/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.dart_lint;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.bandit.FindingInfo;
import com.teamscale.index.findings.dart_lint.DartLintRunner;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

public class DartLintSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String CHECKS_PARAMETER = "checks";
    public static final Version DART_SDK_VERSION = new Version(3, 5);
    private static final String TEMP_DIR_NAME = "TeamscaleDartLint";
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue((Object)CollectionUtils.emptyList());

    public static void verifyVersion() throws IOException, FormatException, ProjectConfigurationException {
        Version versionInfo = DartLintRunner.executeVersionInfo();
        if (!versionInfo.equals((Object)DART_SDK_VERSION)) {
            throw new ProjectConfigurationException("Dart lint version could not be verified. Expected: " + String.valueOf(versionInfo));
        }
    }

    private static @NonNull CodeScopeAware<Map<String, TokenElementInfo>> prepareFilesForAnalysis(@NonNull List<TokenElementInfo> tokenElements, @NonNull File srcDir) throws IOException {
        CodeScopeAware elementToAnalyzePerCodeScope = CodeScopeAware.empty();
        int fileId = 0;
        for (TokenElementInfo tokenElement : tokenElements) {
            String fileName = "file" + fileId++ + ".dart";
            FileSystemUtils.writeFileUTF8((Path)Path.of(new File(srcDir, fileName).toString(), new String[0]), (String)tokenElement.getText());
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement);
            if (!elementToAnalyzePerCodeScope.contains(codeScopeName)) {
                elementToAnalyzePerCodeScope.setValue(codeScopeName, new HashMap());
            }
            ((Map)elementToAnalyzePerCodeScope.getValue(codeScopeName)).put(fileName, tokenElement);
        }
        return elementToAnalyzePerCodeScope;
    }

    public void execute() throws Exception {
        List<TokenElementInfo> elementsToAnalyze = this.getAddedOrChangedTokenElements(Collections.singleton(ELanguage.DART));
        if (elementsToAnalyze.isEmpty()) {
            return;
        }
        try (TemporaryDirectory tmpDir = DartLintSynchronizer.getTempDirectory((String)TEMP_DIR_NAME);){
            CanonicalFile tempDirectory = new CanonicalFile(tmpDir.getPath().toFile());
            File srcDir = new File(tmpDir.getPath().toFile(), "src");
            CodeScopeAware<Map<String, TokenElementInfo>> generatedFilenameToElement = DartLintSynchronizer.prepareFilesForAnalysis(elementsToAnalyze, srcDir);
            CodeScopeAware findingsByPathPerCodeScope = CodeScopeAware.empty();
            for (CodeScopeName codeScopeName : generatedFilenameToElement.getCodeScopeNames()) {
                findingsByPathPerCodeScope.setValue(codeScopeName, (Object)new ListMap());
                if (((List)this.selectedChecks.getValue(codeScopeName)).isEmpty()) continue;
                DartLintRunner.prepareWorkingDirAndConfig(tempDirectory, (List)this.selectedChecks.getValue(codeScopeName), (List<String>)CollectionUtils.emptyList(), (List<String>)CollectionUtils.emptyList(), (List<String>)CollectionUtils.emptyList());
                List<FindingInfo> reportedResults = DartLintRunner.executeAnalysis(tempDirectory);
                this.processResults(reportedResults, codeScopeName, generatedFilenameToElement, (CodeScopeAware<ListMap<String, IndexFinding>>)findingsByPathPerCodeScope);
            }
            this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)findingsByPathPerCodeScope, "DartLint");
        }
    }

    private void processResults(@NonNull List<FindingInfo> reportedResults, CodeScopeName codeScopeName, CodeScopeAware<Map<String, TokenElementInfo>> generatedFilenameToElement, CodeScopeAware<ListMap<String, IndexFinding>> findingsByPathPerCodeScope) {
        Map<String, List<FindingInfo>> groupedResults = reportedResults.stream().collect(Collectors.groupingBy(FindingInfo::path));
        for (Map.Entry<String, List<FindingInfo>> resultsPerFile : groupedResults.entrySet()) {
            CCSMAssert.isFalse((StringUtils.isEmpty((String)resultsPerFile.getKey()) || CollectionUtils.isNullOrEmpty((Collection)resultsPerFile.getValue()) ? 1 : 0) != 0, (String)"Result group must not be empty");
            String fileName = FileSystemUtils.getLastPathSegment((String)resultsPerFile.getKey());
            TokenElementInfo tokenElement = (TokenElementInfo)((Object)((Map)generatedFilenameToElement.getValue(codeScopeName)).get(fileName));
            if (tokenElement == null) {
                LOGGER.error("Unmapped file '{}' in Dart lint results. Skipping file.", (Object)fileName);
                continue;
            }
            LineOffsetConverter offsetConverter = new LineOffsetConverter(tokenElement.getText());
            this.convertResultsToIndexFindings(resultsPerFile.getValue(), offsetConverter, tokenElement, codeScopeName, findingsByPathPerCodeScope);
        }
    }

    private void convertResultsToIndexFindings(@NonNull List<FindingInfo> fileResults, @NonNull LineOffsetConverter offsetConverter, @NonNull TokenElementInfo tokenElement, CodeScopeName codeScopeName, CodeScopeAware<ListMap<String, IndexFinding>> indexFindings) {
        for (FindingInfo finding : fileResults) {
            int rawStartOffset = offsetConverter.getOffset(finding.rowStart());
            int rawEndOffset = offsetConverter.getOffset(finding.rowEnd() + 1) - 1;
            TextRegionLocation textLocation = new TextRegionLocation(tokenElement.getUniformPath(), rawStartOffset, rawEndOffset, finding.rowStart(), finding.rowEnd());
            IndexFinding indexFinding = new IndexFinding(finding.checkId(), "DartLint", finding.message(), (ElementLocation)textLocation);
            ((ListMap)indexFindings.getValue(codeScopeName)).add((Object)tokenElement.getUniformPath(), (Object)indexFinding);
            IndexFindingUtils.setGuidelineMapping((IndexFinding)indexFinding, (String)finding.checkId(), (ELanguage)ELanguage.DART);
        }
    }
}

