/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.teamscale.core.index.IndexCache;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

final class DependencyResolver {
    private final TypeIndex typeIndex;
    private final TypeDependencyIndex typeDependencyIndex;
    private final FunctionWithException<String, List<String>, StorageException> siblingsLookup;

    public DependencyResolver(TypeIndex typeIndex, TypeDependencyIndex typeDependencyIndex, TokenElementIndex contentIndex) {
        this.typeIndex = typeIndex;
        this.typeDependencyIndex = typeDependencyIndex;
        this.siblingsLookup = DependencyResolver.buildSiblingsLookup(contentIndex);
    }

    private static FunctionWithException<String, List<String>, StorageException> buildSiblingsLookup(TokenElementIndex contentIndex) {
        FunctionWithException directoryLookup = directoryPath -> contentIndex.getUniformPathsStartingWith(directoryPath.toString()).stream().map(UniformPathCompatibilityUtil::convert).filter(subPath -> directoryPath.equals((Object)subPath.getParent())).map(UniformPath::toString).toList();
        IndexCache cache = new IndexCache(UnaryOperator.identity(), FunctionWithException.identity(), directoryLookup, elements -> CollectionUtils.mapWithException((Collection)elements, (FunctionWithException)directoryLookup));
        return path -> (List)cache.getValue((Object)UniformPathCompatibilityUtil.convert((String)path).getParent());
    }

    public List<String> getAdditionalReferencedFiles(Set<String> tokenElementsToAnalyze) throws StorageException {
        HashSet<String> knownPaths = new HashSet<String>(tokenElementsToAnalyze);
        HashSet<String> pathsToAnalyze = new HashSet<String>(tokenElementsToAnalyze);
        while (!pathsToAnalyze.isEmpty()) {
            String pathToAnalyze = (String)pathsToAnalyze.iterator().next();
            pathsToAnalyze.remove(pathToAnalyze);
            Set additionalPaths = Stream.of(this.getReferencedPaths(pathToAnalyze), this.getDirectoryPaths(pathToAnalyze)).flatMap(Function.identity()).filter(Predicate.not(knownPaths::contains)).collect(Collectors.toSet());
            knownPaths.addAll(additionalPaths);
            pathsToAnalyze.addAll(additionalPaths);
        }
        return knownPaths.stream().filter(Predicate.not(tokenElementsToAnalyze::contains)).toList();
    }

    private Stream<String> getReferencedPaths(String pathToAnalyze) throws StorageException {
        List<TypeDependencies> typeDependencies = this.typeDependencyIndex.getTypeDependencies(pathToAnalyze);
        if (typeDependencies == null) {
            return Stream.empty();
        }
        HashSet<String> additionalTypes = new HashSet<String>();
        for (TypeDependencies typeDependency : typeDependencies) {
            additionalTypes.addAll((Collection<String>)typeDependency.getDependencies());
        }
        return this.typeIndex.getFilesForTypes(additionalTypes).stream().flatMap(Collection::stream);
    }

    private Stream<String> getDirectoryPaths(String pathToAnalyze) throws StorageException {
        return ((List)this.siblingsLookup.apply((Object)pathToAnalyze)).stream();
    }
}

