/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.swiftlint;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.findings.swiftlint.SwiftLintConfigurationFileGenerator;
import com.teamscale.index.findings.swiftlint.SwiftLintOutputParser;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SwiftLintRunner
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String CHECK_OPTIONS_VALUES_PARAMETER = "check-option-values";
    public static final String CHECK_OPTIONS_TYPES_PARAMETER = "check-option-types";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SWIFTLINT_EXECUTABLE = "swiftlint";
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.empty();
    @StepParameter(value="check-options", optional=true)
    private final CodeScopeAware<List<String>> selectedOptions = CodeScopeAware.empty();
    @StepParameter(value="check-option-values", optional=true)
    private final CodeScopeAware<List<String>> checkOptionValues = CodeScopeAware.empty();
    @StepParameter(value="check-option-types", optional=true)
    private final CodeScopeAware<List<String>> checkOptionTypes = CodeScopeAware.empty();
    private static final int MAX_RETRIES = 3;
    private static final Duration TIMEOUT = (Duration)TeamscaleSystemProperties.SWIFTLINT_TIMEOUT.getValue();

    public void execute() throws Exception {
        CodeScopeAware<List<TokenElementInfo>> elementsByCodeScope = this.getAddedOrChangedTokenElementsByCodeScope(Set.of(ELanguage.SWIFT));
        CodeScopeAware findingsByCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : elementsByCodeScope.getCodeScopeNames()) {
            List tokenElements = (List)elementsByCodeScope.getValue(codeScopeName);
            if (tokenElements.isEmpty()) {
                LOGGER.info("No Swift files in change set for code scope '{}'. Skipping SwiftLint execution.", (Object)codeScopeName);
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            List checksForCodeScope = (List)this.selectedChecks.getValue(codeScopeName);
            if (checksForCodeScope.isEmpty()) {
                LOGGER.info("No SwiftLint checks enabled for code scope '{}'. Skipping SwiftLint execution.", (Object)codeScopeName);
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            this.executeForCodeScope(codeScopeName, tokenElements, checksForCodeScope, (CodeScopeAware<ListMap<String, IndexFinding>>)findingsByCodeScope);
        }
        this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)findingsByCodeScope, SWIFTLINT_EXECUTABLE);
    }

    private void executeForCodeScope(CodeScopeName codeScopeName, List<TokenElementInfo> tokenElements, List<String> checksForCodeScope, CodeScopeAware<ListMap<String, IndexFinding>> findingsByCodeScope) throws IOException {
        try (TemporaryDirectory tempDirectory = SwiftLintRunner.getTempDirectory((String)SWIFTLINT_EXECUTABLE);){
            LOGGER.info("Processing {} Swift file(s) in code scope '{}' using {} enabled SwiftLint check(s) in working directory '{}'.", (Object)tokenElements.size(), (Object)codeScopeName.name(), (Object)checksForCodeScope.size(), (Object)tempDirectory.getPath());
            Map<String, TokenElementInfo> uniformPathToElement = this.prepareSwiftLintInputFiles(tokenElements, tempDirectory.getPath(), codeScopeName);
            ProcessUtils.ExecutionResult result = SwiftLintRunner.executeSwiftLintWithRetry(tempDirectory.getPath().toFile());
            findingsByCodeScope.setValue(codeScopeName, this.processResult(uniformPathToElement, result));
        }
    }

    private Map<String, TokenElementInfo> prepareSwiftLintInputFiles(List<TokenElementInfo> tokenElements, Path tempDirectory, CodeScopeName codeScopeName) throws IOException {
        HashMap<String, TokenElementInfo> uniformPathToElement = new HashMap<String, TokenElementInfo>();
        for (TokenElementInfo tokenElement : tokenElements) {
            Path file = tempDirectory.resolve(tokenElement.getUniformPath());
            FileSystemUtils.writeFileUTF8((Path)file, (String)tokenElement.getText());
            uniformPathToElement.put(tokenElement.getUniformPath(), tokenElement);
        }
        this.writeSwiftLintConfiguration(tempDirectory, codeScopeName);
        return uniformPathToElement;
    }

    private ListMap<String, IndexFinding> processResult(Map<String, TokenElementInfo> uniformPathToElement, ProcessUtils.ExecutionResult result) {
        String stdErr = result.getStderr();
        LOGGER.info(stdErr);
        if (!SwiftLintRunner.wasSuccessfulRun(result)) {
            LOGGER.error("SwiftLint result code: {}", (Object)result.getReturnCode());
            LOGGER.error("Processed files: {}", uniformPathToElement.keySet());
            LOGGER.error("Standard out: {}", (Object)StringUtils.truncateWithEllipsis((String)result.getStdout(), (int)1000));
            LOGGER.error("Standard error: {}", (Object)StringUtils.truncateWithEllipsis((String)stdErr, (int)1000));
        }
        SwiftLintOutputParser outputParser = new SwiftLintOutputParser(this.pathLookupIndex, uniformPathToElement);
        ListMap<String, IndexFinding> findings = outputParser.parseOutput(result.getStdout());
        LOGGER.info("SwiftLint reported {} findings", (Object)((List)findings.getValues()).size());
        return findings;
    }

    private static ProcessUtils.ExecutionResult executeSwiftLintWithRetry(File tempDirectory) throws IOException {
        ProcessUtils.ExecutionResult result;
        int retries = 0;
        List<String> command = List.of(SWIFTLINT_EXECUTABLE, "lint", "--no-cache");
        ProcessBuilder processBuilder = new ProcessBuilder(command).directory(tempDirectory);
        AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(processBuilder);
        while ((result = ProcessUtils.execute((ProcessBuilder)processBuilder, null, (Duration)TIMEOUT)).getReturnCode() == 132 && ++retries <= 3) {
        }
        return result;
    }

    private void writeSwiftLintConfiguration(Path tempDirectory, CodeScopeName codeScopeName) throws IOException {
        Path configurationFile = tempDirectory.resolve(".swiftlint.yml");
        SwiftLintConfigurationFileGenerator configFileGenerator = new SwiftLintConfigurationFileGenerator((List)this.selectedChecks.getValue(codeScopeName), (List)this.selectedOptions.getValue(codeScopeName), (List)this.checkOptionValues.getValue(codeScopeName), (List)this.checkOptionTypes.getValue(codeScopeName));
        FileSystemUtils.writeFileUTF8((Path)configurationFile, (String)configFileGenerator.generateConfiguration());
    }

    private static boolean wasSuccessfulRun(ProcessUtils.ExecutionResult result) {
        return result.getReturnCode() == 0 || result.getReturnCode() == 2;
    }

    public static Pair<Integer, String> getNonAnalysisCommandLineOutput(String ... options) {
        return IntegratedToolUtils.getNonAnalysisCommandLineOutput(SWIFTLINT_EXECUTABLE, true, options);
    }
}

