/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ZipToGitImporterUtils {
    public static final String DOT_GIT_DIR = ".git";
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isExisitingRepository(File gitRepositoryLocation) {
        return new File(gitRepositoryLocation, DOT_GIT_DIR).exists();
    }

    public static String buildEmail(String userName, String emailDomain, String whitespaceReplacement) {
        String localPart = userName.replaceAll("\\s", whitespaceReplacement).toLowerCase();
        return localPart + "@" + emailDomain;
    }

    public static @NonNull Set<String> findMatchingFilesInExport(Pattern filePattern, ZipFile zipFile) {
        HashSet<String> matchingZipFileEntries = new HashSet<String>();
        Enumeration zipFileEntries = zipFile.getEntries();
        while (zipFileEntries.hasMoreElements()) {
            String zipEntryName = ((ZipArchiveEntry)zipFileEntries.nextElement()).getName();
            if (!filePattern.matcher(zipEntryName).matches()) continue;
            matchingZipFileEntries.add(zipEntryName);
        }
        return matchingZipFileEntries;
    }

    public static void feedEachXmlFileToProcessor(ZipFile zipFile, Set<String> xmlFileEntries, IXmlTableProcessor processor, String kindOfFileForMessage) {
        for (String entryName : xmlFileEntries) {
            try {
                String content = AbapGitImporterUtils.readXmlContent(zipFile, entryName);
                processor.processXml(content);
            }
            catch (GitBridgeException e) {
                LOGGER.error("XML parsing error for " + kindOfFileForMessage + " file " + entryName + " within " + zipFile.getName(), (Throwable)e);
            }
        }
    }

    private ZipToGitImporterUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static interface IXmlTableProcessor {
        public void processXml(String var1) throws GitBridgeException;
    }
}

