/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.github.GitHubIssueSynchronizerBase;
import com.teamscale.index.issues.github.client.GitHubIssueClient;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class AppBasedGitHubIssueSynchronizer
extends GitHubIssueSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex optionIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private GitHubInstallationIndex installationIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AccessTokenIndex accessTokenIndex;
    @StepParameter(value="githubServerUrl")
    private String gitHubServerUrl;
    @StepParameter(value="repository-name")
    private String repositoryName;

    @Override
    protected void initialize() throws BugTrackerException {
        this.init();
    }

    @Override
    protected void init() throws BugTrackerException {
        GitHubAppBasedRepositoryAccessHelper<BugTrackerException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<BugTrackerException>(this.gitHubServerUrl, this.repositoryName, this.installationIndex, this.optionIndex, this.accessTokenIndex, BugTrackerException::new, LOGGER);
        try {
            String installationAccessToken = repositoryAccessHelper.getInstallationAccessToken();
            this.setPassword(installationAccessToken);
            this.gitHubClient = new GitHubIssueClient(repositoryAccessHelper.getApplicationDescription().getApiServer(), null, installationAccessToken, LOGGER);
        }
        catch (ServiceCallException | StorageException e) {
            throw new BugTrackerException("Failed to initialize GitHub issue tracker.", e);
        }
        this.determineStandardFieldTypeMappings();
    }

    @Override
    protected PlatformRepositoryIdentifier getRepositoryIdentifier() {
        return PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName);
    }
}

