/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.parser;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

class JiraCustomSprintFieldParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String OPEN_ARRAY_CHARACTER = "\\[";
    private static final String CLOSE_ARRAY_CHARACTER = "]";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private static final String NAME_KEY = "name";

    JiraCustomSprintFieldParser() {
    }

    public static String getSprintNamesOrEmpty(String sprintField) {
        if (JiraCustomSprintFieldParser.isStringNullOrEmpty(sprintField)) {
            LOGGER.warn("Empty or null Jira custom sprint field");
            return "";
        }
        ArrayList<String> sprintNames = new ArrayList<String>();
        try {
            String[] fields;
            String[] jsonStrings = sprintField.split(OPEN_ARRAY_CHARACTER, 2);
            int lastArrayClosure = jsonStrings[1].lastIndexOf(CLOSE_ARRAY_CHARACTER);
            sprintField = sprintField.substring(0, lastArrayClosure);
            for (String fieldString : fields = sprintField.split(COMMA)) {
                String[] field = fieldString.split(EQUALS);
                if (!field[0].equals(NAME_KEY)) continue;
                sprintNames.add(field[1].trim());
            }
            return StringUtils.concat(sprintNames, (String)", ");
        }
        catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException e) {
            LOGGER.warn("Malformed custom sprint field");
            return "";
        }
    }

    private static boolean isStringNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

