/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;

public abstract class IssueUpdaterBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SpecItemIndex specItemIndex;
    @DeltaSource(value=SpecItemIndex.class)
    private KeyDelta delta;

    private List<SpecItem> getUpdatedItems(KeyDelta resolvedDelta) throws StorageException {
        List changedKeys = resolvedDelta.getAddedOrChangedKeysAsStrings();
        return this.specItemIndex.getIssuesForInternalIds(changedKeys);
    }

    private List<TeamscaleIssueId> getDeletedItemIds(KeyDelta resolvedDelta) {
        List deletedKeys = resolvedDelta.getDeletedKeysAsStrings();
        return deletedKeys.stream().map(TeamscaleIssueId::fromInternalId).collect(Collectors.toList());
    }

    public void execute() throws Exception {
        KeyDelta resolvedDelta = this.specItemIndex.resolveDelta(this.delta);
        this.performUpdate(this.getUpdatedItems(resolvedDelta), this.getDeletedItemIds(resolvedDelta));
    }

    protected abstract void performUpdate(List<SpecItem> var1, List<TeamscaleIssueId> var2) throws Exception;
}

