/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.voting.PrometheusVotingTimeHistogram;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public class VotingRecorder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final VotingRecordIndex votingRecordIndex;
    private final RepositoryLogIndex repositoryLogIndex;
    private final ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex;
    private final CommitDescriptor commit;
    private final String reason;
    private final PublicProjectId primaryPublicId;

    public VotingRecorder(PublicProjectId primaryPublicId, VotingRecordIndex votingRecordIndex, RepositoryLogIndex repositoryLogIndex, ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex, CommitDescriptor commit) {
        this(primaryPublicId, votingRecordIndex, repositoryLogIndex, externalResultsPartitionLastUpdateIndex, commit, "Voted on commit.");
    }

    public VotingRecorder(PublicProjectId primaryPublicId, VotingRecordIndex votingRecordIndex, RepositoryLogIndex repositoryLogIndex, ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex, CommitDescriptor commit, String reason) {
        this.primaryPublicId = primaryPublicId;
        this.votingRecordIndex = votingRecordIndex;
        this.repositoryLogIndex = repositoryLogIndex;
        this.commit = commit;
        this.reason = reason;
        this.externalResultsPartitionLastUpdateIndex = externalResultsPartitionLastUpdateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void record(RecordedVotingAction action) throws StorageException {
        VotingRecord record = null;
        try {
            this.logCommitAndRevision();
            VotingResult votingResult = VotingRecorder.vote(action);
            record = this.handleVotingResult(votingResult.votingState, votingResult.timeToVoteMs, votingResult.relevantBuildJobs);
            if (record == null) return;
        }
        catch (VotingException e) {
            try {
                if (e.getRecord().getState() == VotingRecord.EVotingState.ERROR) {
                    LOGGER.error(LoggingUtils.INTERACTION, "Could not vote on " + String.valueOf(this.commit) + ": " + e.getMessage(), (Throwable)e);
                } else {
                    LOGGER.info(LoggingUtils.INTERACTION, "Voting for " + String.valueOf(this.commit) + " terminated with state '" + String.valueOf((Object)e.getRecord().getState()) + "' and message '" + e.getMessage() + "'");
                }
                record = VotingRecorder.getRecordFromVotingException(e);
                if (record == null) return;
            }
            catch (Throwable throwable) {
                if (record == null) throw throwable;
                this.votingRecordIndex.setVotingRecord(this.commit, record);
                if (!record.getTimeToVoteInSeconds().isPresent()) throw throwable;
                ((DistributionDataPoint)PrometheusVotingTimeHistogram.INSTANCE.labelValues(new String[]{this.primaryPublicId.projectId, record.state.name()})).observe((double)record.getTimeToVoteInSeconds().get().longValue());
                throw throwable;
            }
            this.votingRecordIndex.setVotingRecord(this.commit, record);
            if (!record.getTimeToVoteInSeconds().isPresent()) return;
            ((DistributionDataPoint)PrometheusVotingTimeHistogram.INSTANCE.labelValues(new String[]{this.primaryPublicId.projectId, record.state.name()})).observe((double)record.getTimeToVoteInSeconds().get().longValue());
            return;
        }
        this.votingRecordIndex.setVotingRecord(this.commit, record);
        if (!record.getTimeToVoteInSeconds().isPresent()) return;
        ((DistributionDataPoint)PrometheusVotingTimeHistogram.INSTANCE.labelValues(new String[]{this.primaryPublicId.projectId, record.state.name()})).observe((double)record.getTimeToVoteInSeconds().get().longValue());
        return;
    }

    private static @Nullable VotingRecord getRecordFromVotingException(VotingException e) {
        VotingException.Skipped skipped;
        if (e instanceof VotingException.Skipped && !(skipped = (VotingException.Skipped)e).getReason().shouldBeRecorded()) {
            return null;
        }
        return e.getRecord();
    }

    private VotingRecord handleVotingResult(VotingRecord.EVotingState state, @Nullable Long timeToVoteMs, List<MergeRequestBuildJob> relevantBuildJobs) throws StorageException {
        VotingRecord record = null;
        switch (state) {
            case VOTED: 
            case VOTED_POSITIVE: 
            case VOTED_NEGATIVE: 
            case COMMENTED: 
            case VOTING_DISABLED: {
                record = VotingRecord.successful(state, this.commit, this.getVotingComment(state), this.externalResultsPartitionLastUpdateIndex.getPartitionsUpdatedWithCommit(this.commit), relevantBuildJobs);
                record.setTimeToVote(timeToVoteMs);
                LOGGER.info(LoggingUtils.INTERACTION, "Voting status for {}: \"{}\"", (Object)this.commit, (Object)this.getVotingComment(state));
                break;
            }
            case VOTED_INCOMPLETE_BUILD: {
                record = VotingRecord.successful(state, this.commit, this.getVotingComment(state), this.externalResultsPartitionLastUpdateIndex.getPartitionsUpdatedWithCommit(this.commit), relevantBuildJobs);
                record.setTimeToVote(timeToVoteMs);
                LOGGER.info(LoggingUtils.INTERACTION, "Voting status for {}: \"{}\". Waiting for relevant build jobs to finish: {}", (Object)this.commit, (Object)this.getVotingComment(state), relevantBuildJobs);
                break;
            }
            case UNVOTED: {
                throw new AssertionError((Object)"Voting should never be terminated with an UNVOTED state. This state is reserved as an intermediate state and should be replaced during the voting logic.");
            }
            case SKIPPED: 
            case ERROR: {
                if (timeToVoteMs == null) break;
                ((DistributionDataPoint)PrometheusVotingTimeHistogram.INSTANCE.labelValues(new String[]{this.primaryPublicId.projectId, state.name()})).observe((double)TimeUnit.MILLISECONDS.toSeconds(timeToVoteMs));
                break;
            }
            default: {
                throw new AssertionError((Object)"Found unexpected voting state.");
            }
        }
        return record;
    }

    private String getVotingComment(VotingRecord.EVotingState state) throws StorageException {
        String string = this.getRevision();
        return "Processed commit " + string + ". " + (switch (state) {
            case VotingRecord.EVotingState.VOTED -> "Vote inconclusive. No new findings, but still other unresolved findings in changed code.";
            case VotingRecord.EVotingState.VOTED_POSITIVE -> "Positive vote performed due to no findings or test gaps being present.";
            case VotingRecord.EVotingState.VOTED_NEGATIVE -> "Negative vote performed due to findings or test gaps being present.";
            case VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD -> "The vote is incomplete as Teamscale is still waiting for relevant build jobs to finish.";
            case VotingRecord.EVotingState.COMMENTED -> "Added detailed line comments that indicate findings or test gaps to the merge request (voting is disabled or not supported by the corresponding code collaboration platform, but line comments are enabled).";
            case VotingRecord.EVotingState.VOTING_DISABLED -> "No vote because voting is disabled or not supported by the corresponding code collaboration platform.";
            default -> this.reason;
        });
    }

    private String getRevision() throws StorageException {
        RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(this.commit);
        if (repositoryLogEntry != null) {
            return repositoryLogEntry.getRevision();
        }
        return String.valueOf(this.commit) + " (Revision not available)";
    }

    private void logCommitAndRevision() throws StorageException {
        RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(this.commit);
        if (repositoryLogEntry != null) {
            LOGGER.info(LoggingUtils.INTERACTION, () -> "Voting on " + String.valueOf(this.commit) + " with revision " + repositoryLogEntry.getRevision());
        } else {
            LOGGER.info(LoggingUtils.INTERACTION, () -> "Voting on " + String.valueOf(this.commit) + " (Revision not available)");
        }
    }

    private static VotingResult vote(RecordedVotingAction action) throws VotingException {
        try {
            return action.vote();
        }
        catch (ServiceCallException | ExecutionCanceledException | StorageException e) {
            throw new VotingException.Error(null, e);
        }
    }

    @FunctionalInterface
    public static interface RecordedVotingAction {
        public VotingResult vote() throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException;
    }

    public record VotingResult(VotingRecord.EVotingState votingState, @Nullable Long timeToVoteMs, List<MergeRequestBuildJob> relevantBuildJobs) {
    }
}

