/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion30GranularityToStartDateMigration {
    private static final String DISABLED_ANALYSIS_GRANULARITY = "{\"ageBoundaries\" : [ ], \"branchConfigurations\" : [ {\"branchNamePattern\" : \".*\", \"periodicitySeconds\" : [ 0 ]}]}";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        Object analysisGranularity = holder.getAdditionalProperties().remove("analysisGranularity");
        if (analysisGranularity == null) {
            analysisGranularity = JsonUtils.deserializeFromJson((String)DISABLED_ANALYSIS_GRANULARITY);
        }
        if (analysisGranularity instanceof Map) {
            Map map = (Map)analysisGranularity;
            holder.setAdditionalProperty("branchingConfiguration", ProjectVersion30GranularityToStartDateMigration.convertGranularity(map));
        }
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static Map<String, Object> convertGranularity(Map<String, Object> analysisGranularity) {
        ArrayList configurations = new ArrayList();
        List ageBoundaries = (List)analysisGranularity.get("ageBoundaries");
        List branchConfigurations = (List)analysisGranularity.get("branchConfigurations");
        for (Map branchConfiguration : branchConfigurations) {
            String branchNamePattern = (String)branchConfiguration.get("branchNamePattern");
            List periodicitySeconds = (List)branchConfiguration.get("periodicitySeconds");
            int lastNonNegativeIndex = ProjectVersion30GranularityToStartDateMigration.findLastNonNegativeIndex(periodicitySeconds);
            String startDate = lastNonNegativeIndex < 0 ? "2050-01-01" : (lastNonNegativeIndex >= ageBoundaries.size() ? "1970-01-01" : (String)ageBoundaries.get(lastNonNegativeIndex));
            LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
            configuration.put("branchNamePattern", branchNamePattern);
            configuration.put("startDate", startDate);
            configurations.add(configuration);
        }
        return new LinkedHashMap<String, Object>(Map.of("branchConfigurations", configurations));
    }

    private static int findLastNonNegativeIndex(List<Integer> periodicitySeconds) {
        for (int i = periodicitySeconds.size() - 1; i >= 0; --i) {
            if (periodicitySeconds.get(i) < 0) continue;
            return i;
        }
        return -1;
    }
}

