/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v144_profiler_config_permissions;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v116_dashboards.V116EBasicRole;
import com.teamscale.index.migration.v116_dashboards.V116ESubjectType;
import com.teamscale.index.migration.v116_dashboards.V116InternalProjectId;
import com.teamscale.index.migration.v116_dashboards.V116ProjectIdBase;
import com.teamscale.index.migration.v116_dashboards.V116PublicProjectId;
import com.teamscale.index.migration.v144_profiler_config_permissions.V144EBasicPermissionScope;
import com.teamscale.index.migration.v144_profiler_config_permissions.V144SubjectRoleAssignments;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion144ProfilerConfigPermissionsForAdmins
implements IPointwiseStorageMigrator {
    private static final String PERMISSION_INDEX_NAME = "permissions";
    private static final String INSTANCE_ADMIN_ROLE = "Instance Admin";
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrateVersion144ProfilerConfigPermissionsForAdmins() {
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.SubjectRoleAssignments", V144SubjectRoleAssignments.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EBasicPermissionScope", V144EBasicPermissionScope.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ESubjectType", V116ESubjectType.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.InternalProjectId", V116InternalProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.PublicProjectId", V116PublicProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ProjectIdBase", V116ProjectIdBase.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V144;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public String getStoreName() {
        return PERMISSION_INDEX_NAME;
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        if (!StringUtils.bytesToString((byte[])key).startsWith("ROLE_ASSIGNMENTS")) {
            return PairList.from((Object)key, (Object)value);
        }
        V144SubjectRoleAssignments roleAssignment = (V144SubjectRoleAssignments)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value));
        boolean hasInstanceAdminRights = roleAssignment.getGlobalRoleNames().contains(INSTANCE_ADMIN_ROLE);
        if (hasInstanceAdminRights) {
            roleAssignment.addGlobalBasicRole(V144EBasicPermissionScope.PROFILER_CONFIGURATIONS, V116EBasicRole.OWNER);
        }
        return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(roleAssignment)));
    }
}

