/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

public class MypyReportEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern ERROR_PATTERN = Pattern.compile("^\\s*(?<path>[^:]+):((?<lineNumber>\\d+):)?((?<offset>\\d+):)?\\s+(?<kind>(error|note)):\\s+(?<message>.*?)(\\s+\\[(?<category>[^]]*)])?\\s*$");
    private static final Pattern UNUSED_TYPE_IGNORE_COMMENT = Pattern.compile("^.* error: unused .* comment$");
    public static final String SUMMARY_LINE_PREFIX = "Found ";
    public final String path;
    public final int line;
    public final String message;
    public final String errorCode;

    MypyReportEntry(String path, int line, String message, String errorCode) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)errorCode);
        this.path = path;
        this.line = line;
        this.message = message;
        this.errorCode = errorCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MypyReportEntry that = (MypyReportEntry)o;
        return this.line == that.line && this.path.equals(that.path) && this.message.equals(that.message) && this.errorCode.equals(that.errorCode);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.line, this.message, this.errorCode);
    }

    public String toString() {
        return "MypyReportEntry{path='" + this.path + "', line=" + this.line + ", message='" + this.message + "', ruleId='" + this.errorCode + "'}";
    }

    public static Optional<MypyReportEntry> createFromReportLine(String line) {
        if (line == null) {
            return Optional.empty();
        }
        Matcher matcher = ERROR_PATTERN.matcher(line);
        if (!matcher.matches()) {
            if (!line.startsWith(SUMMARY_LINE_PREFIX)) {
                LOGGER.warn("Encountered unknown line format in MyPy report: {}", (Object)line);
            }
            return Optional.empty();
        }
        String kind = matcher.group("kind");
        if (kind.equals("note")) {
            return Optional.empty();
        }
        String category = matcher.group("category");
        String message = matcher.group("message");
        if (StringUtils.isEmpty((String)category)) {
            if (!UNUSED_TYPE_IGNORE_COMMENT.matcher(line).matches()) {
                LOGGER.warn("Encountered error line \"{}\" in MyPy report without error code. Please make sure the --show-error-codes option is enabled when running MyPy. MyPy errors without error codes are mapped to the \"misc\" error code.", (Object)line);
                return Optional.empty();
            }
            category = "misc";
        }
        String path = matcher.group("path");
        int lineNumber = Integer.parseInt(matcher.group("lineNumber"));
        return Optional.of(new MypyReportEntry(path, lineNumber, message, category));
    }
}

