/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.xcresult;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.report.testexecution.TestReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.lib.commons.collections.CollectionUtils;

public class XCResultJsonReportParser
extends TestReportParserBase {
    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        JsonNode jsonReport;
        try {
            jsonReport = JsonUtils.deserializeFromJson((String)report);
        }
        catch (JsonSerializationException e) {
            throw new ReportParserException("Unable to parse XCResult JSON report", (Throwable)e);
        }
        List<JsonNode> tests = XCResultJsonReportParser.findTestMetadataNodes(jsonReport);
        if (tests.isEmpty()) {
            LOGGER.warn("Expected test execution report to contain at least one test not found in JSON report");
        }
        for (JsonNode test : tests) {
            TestExecution.Builder builder = XCResultJsonReportParser.testFromJsonNode(test);
            if (builder == null) continue;
            this.reportTestExecution(builder);
        }
    }

    private static List<JsonNode> findTestMetadataNodes(JsonNode jsonReport) {
        return CollectionUtils.filter((Collection)jsonReport.findParents("identifier"), node -> XCResultJsonReportParser.hasNodeType(node, "ActionTestMetadata"));
    }

    private static boolean hasNodeType(JsonNode node, String type) {
        JsonNode typeNode = node.get("_type");
        if (typeNode != null && typeNode.has("_name")) {
            return typeNode.get("_name").textValue().equals(type);
        }
        return false;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TestExecution.Builder testFromJsonNode(JsonNode jsonNode) throws ReportParserException {
        JsonNode identifierNode = jsonNode.get("identifier");
        JsonNode statusNode = jsonNode.get("testStatus");
        JsonNode durationNode = jsonNode.get("duration");
        if (identifierNode == null || statusNode == null || durationNode == null) {
            LOGGER.error("XCResult JSON file is missing required field(s).");
            return null;
        }
        double duration = XCResultJsonReportParser.roundToXPostCommaDigits(durationNode.get("_value").asDouble(), 5);
        String identifier = identifierNode.get("_value").textValue();
        ETestExecutionResult result = XCResultJsonReportParser.getTestExecutionResultFromString(statusNode.get("_value").textValue());
        return TestExecution.Builder.fromRelativePath((String)identifier).setResult(result).setDurationInSeconds(duration);
    }

    private static double roundToXPostCommaDigits(double value, int postCommaDigits) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("#." + "#".repeat(postCommaDigits), symbols);
        return Double.parseDouble(df.format(value));
    }

    private static ETestExecutionResult getTestExecutionResultFromString(String testResultString) throws ReportParserException {
        if ("Success".equalsIgnoreCase(testResultString) || "Expected Failure".equalsIgnoreCase(testResultString)) {
            return ETestExecutionResult.PASSED;
        }
        if ("Failure".equalsIgnoreCase(testResultString)) {
            return ETestExecutionResult.FAILURE;
        }
        if ("Skipped".equalsIgnoreCase(testResultString)) {
            return ETestExecutionResult.SKIPPED;
        }
        if ("Mixed".equalsIgnoreCase(testResultString)) {
            return ETestExecutionResult.INCONCLUSIVE;
        }
        throw new ReportParserException("Unexpected test status: " + testResultString);
    }
}

