/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;

final class RevisionIsDateInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimpleDateFormat dateFormat;

    private RevisionIsDateInterpretation(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    protected Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) {
        try {
            return Optional.of(new CommitDescriptor(branchName, this.dateFormat.parse(revision).getTime()));
        }
        catch (ParseException e) {
            LOGGER.error("Could not parse date '{}': {}", (Object)revision, (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    public static RevisionIsDateInterpretation create(String dateFormat) throws RepositoryException {
        try {
            return new RevisionIsDateInterpretation(new SimpleDateFormat(dateFormat));
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("Invalid date format '" + dateFormat + "': " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ERevisionType getRevisionType() {
        return ERevisionType.DATE;
    }
}

