/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.filesystem.FileSystemCacheEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={Serializable.class, RepositoryChangeSet.class, FileSystemCacheEntry.class})
public class FileSystemCacheIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String INDEX_NAME = "fs-cache";
    private static final String KEY_DELIMITER = "#-#";

    FileSystemCacheIndex(IStore store) {
        super(store);
    }

    private void setValue(String key, Serializable value) throws StorageException {
        this.store.putWithString(key, StorageUtils.serialize((Serializable)value));
    }

    private <T extends Serializable> T getValue(String key) throws StorageException {
        return (T)StorageUtils.deserialize((byte[])this.store.getWithString(key));
    }

    private static String createBasePathKeyPrefix(String basePath) {
        return EEntryType.CACHE_ENTRY.toString() + basePath + KEY_DELIMITER;
    }

    private static String createFileSystemCacheEntryKey(String basePath, String relativePathToFile) {
        return FileSystemCacheIndex.createBasePathKeyPrefix(basePath) + relativePathToFile;
    }

    void setFileSystemCacheEntry(String basePath, String relativePathToFile, FileSystemCacheEntry value) throws StorageException {
        this.setValue(FileSystemCacheIndex.createFileSystemCacheEntryKey(basePath, relativePathToFile), value);
    }

    void setChangeSet(RepositoryChangeSet changeSet) throws StorageException {
        this.setValue(EEntryType.CHANGESET.toString(), (Serializable)((Object)changeSet));
    }

    RepositoryChangeSet getChangeSet() throws StorageException {
        return (RepositoryChangeSet)((Object)this.getValue(EEntryType.CHANGESET.toString()));
    }

    FileSystemCacheEntry getFileSystemCacheEntry(String basePath, String relativePathToFile) throws StorageException {
        return (FileSystemCacheEntry)this.getValue(FileSystemCacheIndex.createFileSystemCacheEntryKey(basePath, relativePathToFile));
    }

    List<FileSystemCacheEntry> getFileSystemCacheEntries(String basePath) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.store.getEntriesStartingWith(FileSystemCacheIndex.createBasePathKeyPrefix(basePath)).extractSecondList(), StorageUtils::deserialize);
    }

    void removeFileSystemCacheEntry(String basePath, String relativePathToFile) throws StorageException {
        this.store.removeWithString(FileSystemCacheIndex.createFileSystemCacheEntryKey(basePath, relativePathToFile));
    }

    private static enum EEntryType {
        CACHE_ENTRY,
        CHANGESET;

    }
}

