/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitChangeRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitClient;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestProvider;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitPullRequestDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep
public class AzureDevOpsGitMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<AzureDevOpsGitMergeRequestProvider, AzureDevOpsGitPullRequestDto> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-name")
    private String repositoryName;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;

    @Override
    protected AzureDevOpsGitMergeRequestProvider createMergeRequestProvider() throws StorageException {
        ExternalCredentials credentials = this.getExternalCredentials(this.accountIdentifier);
        AzureDevOpsGitClient client = new AzureDevOpsGitClient(credentials, this.repositoryName, StorageException::new, LOGGER);
        return new AzureDevOpsGitMergeRequestProvider(this.repositoryName, client);
    }

    @Override
    protected String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return AzureDevOpsGitChangeRetriever.class;
    }
}

