/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.teamscale.core.index.CommitDescriptorIndex;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CommitsOnBranchCache {
    private final Cache<String, List<ParentedCommitDescriptor>> branchCommitsCache = CacheBuilder.newBuilder().build();
    private final CommitDescriptorIndex commitDescriptorIndex;

    public CommitsOnBranchCache(CommitDescriptorIndex commitDescriptorIndex) {
        this.commitDescriptorIndex = commitDescriptorIndex;
    }

    public List<ParentedCommitDescriptor> getCommitsOnBranchFromCache(String branch) throws StorageException {
        try {
            return (List)this.branchCommitsCache.get((Object)branch, () -> this.commitDescriptorIndex.getCommitsForBranch(branch));
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), StorageException.class);
            return (List)CCSMAssert.fail((String)"Unexpected exception was thrown: ", (Throwable)e);
        }
    }

    public Optional<CommitDescriptor> getLatestCommitOnBranchFromCache(String branch) throws StorageException {
        List<ParentedCommitDescriptor> commits = this.getCommitsOnBranchFromCache(branch);
        return Optional.ofNullable((CommitDescriptor)CollectionUtils.getLast(commits));
    }
}

