/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.cross_repo_merge_requests;

import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={CrossRepositoryMergeRequestSourceBranch.class})
public class CrossRepositoryMergeRequestSourceBranchesIndex
implements IProjectIndexWithDynamicName {
    public static final String BASE_NAME = "cross-repo-merge-request-source-branches";
    private static final String ACTIVE_BRANCHES_KEY_PREFIX = "active";
    private static final String INACTIVE_BRANCHES_KEY_PREFIX = "inactive";
    private final ValueIndex<CrossRepositoryMergeRequestSourceBranch> activeBranchesDelegateIndex;
    private final ValueIndex<CrossRepositoryMergeRequestSourceBranch> inactiveBranchesDelegateIndex;
    private UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> activeSourceBranches;
    private UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> inactiveSourceBranches;
    private String indexName;

    public CrossRepositoryMergeRequestSourceBranchesIndex(IStore store) {
        this.activeBranchesDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, ACTIVE_BRANCHES_KEY_PREFIX));
        this.inactiveBranchesDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, INACTIVE_BRANCHES_KEY_PREFIX));
    }

    public static String createIndexName(String connectorIdentifier) {
        return connectorIdentifier + "-cross-repo-merge-request-source-branches";
    }

    public void setName(String indexName) {
        this.indexName = indexName;
    }

    public String getName() {
        return this.indexName;
    }

    public UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> readAllActiveBranches() throws StorageException {
        if (this.activeSourceBranches == null) {
            this.activeSourceBranches = CollectionUtils.asUnmodifiable((List)this.activeBranchesDelegateIndex.getAllEntries().extractSecondList());
        }
        return this.activeSourceBranches;
    }

    public boolean updateActive(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
        String key = CrossRepositoryMergeRequestSourceBranchesIndex.getKey(branch);
        if (branch.equals(this.activeBranchesDelegateIndex.getValue(key))) {
            return false;
        }
        this.inactiveSourceBranches = null;
        this.activeSourceBranches = null;
        this.inactiveBranchesDelegateIndex.removeValue(key);
        this.activeBranchesDelegateIndex.setValue(key, (Object)branch);
        return true;
    }

    public void storeInactive(CrossRepositoryMergeRequestSourceBranch branch) throws StorageException {
        this.activeSourceBranches = null;
        this.inactiveSourceBranches = null;
        String key = CrossRepositoryMergeRequestSourceBranchesIndex.getKey(branch);
        this.activeBranchesDelegateIndex.removeValue(key);
        this.inactiveBranchesDelegateIndex.setValue(key, (Object)branch);
    }

    public void storeInactive(List<CrossRepositoryMergeRequestSourceBranch> branches) throws StorageException {
        this.activeSourceBranches = null;
        this.inactiveSourceBranches = null;
        List<String> keys = branches.stream().map(CrossRepositoryMergeRequestSourceBranchesIndex::getKey).toList();
        this.activeBranchesDelegateIndex.removeValues(keys);
        this.inactiveBranchesDelegateIndex.setValues(PairList.zip(keys, branches));
    }

    public UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> readAllInactiveBranches() throws StorageException {
        if (this.inactiveSourceBranches == null) {
            this.inactiveSourceBranches = CollectionUtils.asUnmodifiable((List)this.inactiveBranchesDelegateIndex.getAllEntries().extractSecondList());
        }
        return this.inactiveSourceBranches;
    }

    public void removeBranch(CrossRepositoryMergeRequestSourceBranch sourceBranch) throws StorageException {
        this.inactiveSourceBranches = null;
        this.inactiveBranchesDelegateIndex.removeValue(CrossRepositoryMergeRequestSourceBranchesIndex.getKey(sourceBranch));
    }

    private static String getKey(CrossRepositoryMergeRequestSourceBranch branch) {
        return branch.localBranchName();
    }
}

