/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.git.gerrit.GerritCommitInfo;
import com.teamscale.index.repository.git.gerrit.GerritPatchSetInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.eclipse.jgit.lib.Ref;

public final class GerritUtils {
    public static final String REVIEW_TAG = "autogenerated:teamscale";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String GERRIT_BRANCH_PREFIX = "gerrit/";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    public static Optional<ParentedCommitDescriptor> getLastRealCommitOnBranch(List<ParentedCommitDescriptor> commitsForBranch, RepositoryLogIndex repositoryLogIndex) throws StorageException {
        for (int i = commitsForBranch.size() - 1; i >= 0; --i) {
            ParentedCommitDescriptor commit = commitsForBranch.get(i);
            RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry((CommitDescriptor)commit);
            if (repositoryLogEntry == null || repositoryLogEntry.containsRepositoryIdentifier(identifier -> StringUtils.startsWith((CharSequence)identifier, (CharSequence)"Finding flagging uploads"))) continue;
            return Optional.of(commit);
        }
        return Optional.empty();
    }

    static Collection<GerritCommitInfo> parseChangeReferences(Collection<Ref> changeReferences) {
        ArrayList<GerritCommitInfo> parsedReferences = new ArrayList<GerritCommitInfo>();
        for (Ref changeRef : changeReferences) {
            Optional<GerritCommitInfo> gerritCommitInformation = GerritUtils.parseChangeReference(changeRef.getName(), changeRef.getObjectId().getName());
            if (gerritCommitInformation.isEmpty()) {
                LOGGER.warn("Could not parse ref: " + changeRef.getName() + ". Skipping...");
                continue;
            }
            parsedReferences.add(gerritCommitInformation.get());
        }
        return parsedReferences;
    }

    static Optional<GerritCommitInfo> parseChangeReference(String changeReferenceName, String gitRevision) {
        String[] parts = changeReferenceName.split("/");
        if (parts.length != 5) {
            return Optional.empty();
        }
        String changeNumber = parts[3];
        if (!NUMBER_PATTERN.matcher(changeNumber).matches()) {
            return Optional.empty();
        }
        String patchSetNumber = parts[4];
        if (!NUMBER_PATTERN.matcher(patchSetNumber).matches()) {
            return Optional.empty();
        }
        return Optional.of(new GerritCommitInfo(Long.parseLong(changeNumber), Long.parseLong(patchSetNumber), gitRevision));
    }

    public static boolean isGerritBranch(String branchName) {
        return branchName.startsWith(GERRIT_BRANCH_PREFIX);
    }

    public static GerritPatchSetInfo parseGerritBranch(String gerritBranchName) {
        String[] branchParts = gerritBranchName.split("/");
        Preconditions.checkState((branchParts.length == 3 ? 1 : 0) != 0);
        return new GerritPatchSetInfo(Long.parseLong(branchParts[1]), Long.parseLong(branchParts[2]));
    }

    public static Optional<GerritPatchSetInfo> determineLatestPatchSet(List<String> gerritBranchNames) {
        HashSet<GerritPatchSetInfo> patchSets = new HashSet<GerritPatchSetInfo>();
        for (String gerritBranchName : gerritBranchNames) {
            patchSets.add(GerritUtils.parseGerritBranch(gerritBranchName));
        }
        return patchSets.stream().max(Comparator.comparingLong(GerritPatchSetInfo::getPatchSetNumber));
    }

    public static String getGerritBranchName(long changeNumber, long patchSetNumber) {
        return GerritUtils.getGerritBranchNamePrefix(changeNumber) + patchSetNumber;
    }

    public static String getGerritBranchNamePrefix(long changeNumber) {
        return GERRIT_BRANCH_PREFIX + changeNumber + "/";
    }

    public static String getChangeNumber(String gerritBranchName) {
        return Long.toString(GerritUtils.parseGerritBranch(gerritBranchName).getChangeNumber());
    }

    private GerritUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

